/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: binscore.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */


#include <math.h>

#include "interspecies.h"
#include "wminteg.h"
#include "binbasecount.h"

double binscore(params *v,int nbin) 
{
    double weightb;
    int n,m,mlimit;
    double na,nc,ng,nt,ma,mc,mg,mt;

    binbasecount *thisbinbase;
    binbasecount *thispriorbinbase;
    GArray *onebinbase;
    GPtrArray *wincol1;
    window *currwin;

    weightb=0.0;

    thisbinbase=g_ptr_array_index((v->binbase),nbin-1);

    /***check this color has a prior****/
    if((v->priorbinbase)->len > nbin-1)
      {
	thispriorbinbase = g_ptr_array_index(v->priorbinbase,nbin-1);
      }
    else
      {
	thispriorbinbase = NULL;
      }

    if (v->rcsymm)
        mlimit=v->wwidth/2;
    else
        mlimit=v->wwidth;
    /**run over all the columns in this colour**/
    for (m=0; m<mlimit; m++) 
      {
	onebinbase=g_ptr_array_index(thisbinbase,m);
	na=g_array_index(onebinbase,double,0);
	nc=g_array_index(onebinbase,double,1);
	ng=g_array_index(onebinbase,double,2);
	nt=g_array_index(onebinbase,double,3);
	
	if(thispriorbinbase != NULL)
	  {
	    /***prior basecounts for this color***/
	    onebinbase = g_ptr_array_index(thispriorbinbase,m);
	    ma=g_array_index(onebinbase,double,0);
	    mc=g_array_index(onebinbase,double,1);
	    mg=g_array_index(onebinbase,double,2);
	    mt=g_array_index(onebinbase,double,3);
	    /***wm integral taking prior basecounts into account****/
	    weightb += wminteg(na+ma,nc+mc,ng+mg,nt+mt);
	    weightb -= wminteg(ma,mc,mg,mt);
	  }
	else
	  {
	    /**wm integral for the basecounts***/
	    weightb=weightb+wminteg(na,nc,ng,nt);
	  }
	/**set of windows for this colour***/
	wincol1=g_ptr_array_index((v->bin),nbin);
	for (n=0; n<wincol1->len; n++) {
	  /**single window in this colour, subtract background contribution***/
	  currwin=g_ptr_array_index(wincol1,n);
	  if (v->rcsymm) {
	    weightb=weightb-g_array_index(currwin->bgcount,double,v->wwidth-1-m);
	    weightb=weightb-g_array_index(currwin->bgcount,double,m);
	  } else {
	    if (currwin->dir)
	      weightb=weightb-g_array_index(currwin->bgcount,double,v->wwidth-1-m);
	    else
	      weightb=weightb-g_array_index(currwin->bgcount,double,m);
	  }
	}
      }


    wincol1=g_ptr_array_index((v->bin),nbin);


    /***contribution from window chem pot***/
    weightb=weightb-(v->mu)*(wincol1->len);
    /***contribution from colour chem pot only if there are windows in this color***/
    if(wincol1->len > 0)
      weightb=weightb-(v->lambda);
    return weightb;
}

