/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/15 06:59:44 $ 
 * $Id: initbinconfig.c,v 1.2 2005/05/15 06:59:44 rsidd Exp $ 
 */

/* Erik van Nimwegen June 29 2005                             *
 * If the initialization file has less colours than the number
   of initialized prior WMs then we add bins for these prior WMs *
*/





#include <stdio.h>

#include "interspecies.h"
#include "initbins.h"

/* The structure sorts windows into bins... for use by the gibbs
 * sampler.  Bins are ordered by colour, 0 (ie, window is free), 1,
 * 2... 
 *
 * bin is a GPtrArray (array of pointers) each of which points
 * to a GPtrArray of windows.  Complicated but looked the most
 * flexible...
 *
 * This routine assigns certain specified windows to bins.  Windows
 * are specified by their starting positions on sequences.
 *
 */

/**this reads input file and sets desired number of windows and colors from it****/
void initwincolnum(params *v)
{
  int thisseq,thisstart,thiscolour,thisdir,highestcolour,lowestcolour,numwin,numcol;
  FILE* inputfile;
  inputfile=fopen(v->posfile,"r");
  if (inputfile==NULL) {
    fprintf(stderr, "Input file %s does not exist: continuing\n",
	    v->posfile);
    return;
  }
  numwin = 0;
  highestcolour = 0;
  lowestcolour = 10000;
   while (fscanf(inputfile,"%d  %d  %d  %d",&thisseq,&thisstart,&thiscolour,&thisdir) != EOF) {
     ++numwin;
     if(thiscolour > highestcolour)
       highestcolour = thiscolour;
     if(thiscolour < lowestcolour)
       lowestcolour = thiscolour;
   }
   numcol = highestcolour-lowestcolour+1;
   /***some sanity checks and overrides. This could be better, i.e. we should probably quit with an error
       if the input file is giving numbers that don't make sense****/
   if(v->deswin<0)
     v->deswin = numwin;
   if(v->descol<0)
     v->descol = numcol;
   if(v->descol > v->deswin)
     v->descol = v->deswin;

   fclose(inputfile);
   return;
}


int initbinconfig(params *v) 
{
    int n,m;
    window *windowhandle, *window2;
    GPtrArray *currseq,*binwin1;

    GArray *seq,*start,*colour,*dir;
    int thisseq,thisstart,thiscolour,thisdir;

    FILE* inputfile;


    initbins(v);

    inputfile=fopen(v->posfile,"r");
    if (inputfile==NULL) {
        fprintf(stderr, "Input file %s does not exist: continuing\n",
				v->posfile);
        return 1;
    }
    
    seq=g_array_new(TRUE,TRUE,sizeof(int));
    start=g_array_new(TRUE,TRUE,sizeof(int));
    colour=g_array_new(TRUE,TRUE,sizeof(int));
    dir=g_array_new(TRUE,TRUE,sizeof(int));

    while (fscanf(inputfile,"%d  %d  %d  %d",&thisseq,&thisstart,&thiscolour,&thisdir) != EOF) {
        g_array_append_val(seq,thisseq);
        g_array_append_val(start,thisstart);
        g_array_append_val(colour,thiscolour);
        g_array_append_val(dir,thisdir);
    }

    for (n=0; n<seq->len; n++) {
        thiscolour=g_array_index(colour,int,n);
        thisseq=g_array_index(seq,int,n);
        thisdir=g_array_index(dir,int,n);
        if (thisseq>=(v->seqwin)->len) {
           fprintf(stderr, "Inconsistent init file %s (bad specified sequence number):\nIgnoring remainder of file, continuing\n",v->posfile);
           return 1;
        }
        if ((thisdir != 0)&&(thisdir != 1)) {
            fprintf(stderr, "Error in init file %s (dir must be 0 or 1):\nIgnoring reminder of file, continuing\n",v->posfile);
            return 1;
        }
        thisstart=g_array_index(start,int,n);
        currseq=g_ptr_array_index((v->seqwin),thisseq);
        if (thisstart>=currseq->len) {
           fprintf(stderr, "Inconsistent init file %s (bad specified start position):\nIgnoring remainder of file, continuing\n",v->posfile);
           return 1;
        }
        windowhandle=g_ptr_array_index(currseq,thisstart);
        if (windowhandle==NULL) {
           fprintf(stderr, "Inconsistent init file %s (no legitimate window here):\nIgnoring remainder, continuing\n",v->posfile);
           return 1;
        }
        if (windowhandle->blocked) {
           fprintf(stderr, "Inconsistent init file %s (specified windows block each other):\nIgnoring remainder, continuing\n",v->posfile);
           return 1;
        }
        while (thiscolour>=(v->bin)->len) {
            binwin1=g_ptr_array_new();
            g_ptr_array_add((v->bin),binwin1);
        }
        binwin1=g_ptr_array_index((v->bin),thiscolour);
        g_ptr_array_add(binwin1,windowhandle);
        windowhandle->colour=thiscolour;
        windowhandle->dir=thisdir;
        for (m=0; m<windowhandle->blockedwins->len; m++) {
            window2=g_ptr_array_index((windowhandle->blockedwins),m);
            g_ptr_array_add((window2->blockers),windowhandle);
            window2->blocked=1;
        }
        binwin1=g_ptr_array_index((v->bin),0);
        g_ptr_array_remove_fast(binwin1,windowhandle);
    }
    g_array_free(seq,TRUE);
    g_array_free(start,TRUE);
    g_array_free(colour,TRUE);

    /***if we have initialized less colors than there are prior WMs, add colors for those***/
    /***note, these colors are initialized with no windows in them*************************/
    while((v->bin)->len< ((v->priorbinbase)->len+1))
      {
	binwin1=g_ptr_array_new();
	g_ptr_array_add((v->bin),binwin1);
      }
    
    return 0;

}

