/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: initpermblocked.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include "interspecies.h"
#include <stdio.h>

int initpermblocked(params *v)
{
    int n;
    window *windowhandle;
    FILE *inputfile;

    GPtrArray *currseq;
    GArray *seq,*start,*len;
    int thisseq, thisstart, thislen,thispos;

    inputfile=fopen(v->blockedfile,"r");
    seq=g_array_new(TRUE,TRUE,sizeof(int));
    start=g_array_new(TRUE,TRUE,sizeof(int));
    len=g_array_new(TRUE,TRUE,sizeof(int));

    if (inputfile==NULL) {
        fprintf(stderr, "Input file %s does not exist: continuing\n",v->blockedfile);
        return 1;
    }

    while (fscanf(inputfile,"%d  %d  %d",&thisseq,&thisstart,&thislen) != EOF) {
        g_array_append_val(seq,thisseq);
        g_array_append_val(start,thisstart);
        g_array_append_val(len,thislen);
    }

    for (n=0; n<seq->len; n++) {
        thislen=g_array_index(len,int,n);
        thisseq=g_array_index(seq,int,n);
        if (thisseq>=(v->seqwin)->len) {
           fprintf(stderr, "Inconsistent input file %s (bad specified sequence number):\nIgnoring remainder of file, continuing\n",v->blockedfile);
           return 1;
        }
        thisstart=g_array_index(start,int,n);
        currseq=g_ptr_array_index((v->seqwin),thisseq);
        if (thisstart>=currseq->len) {
           fprintf(stderr, "Inconsistent input file %s (bad specified start position):\nIgnoring remainder of file, continuing\n",v->blockedfile);
           return 1;
        }

        for (thispos=thisstart-(v->wwidth)+1; thispos<thisstart+thislen;
                        thispos++) {
            if ((thispos>=0)&&(thispos<currseq->len)) {
                windowhandle=g_ptr_array_index(currseq,thispos);
                if (windowhandle != NULL)
                    windowhandle->permblocked=1;
            }
        }

    }

    g_array_free(seq,TRUE);
    g_array_free(start,TRUE);
    g_array_free(len,TRUE);


    return 0;

}

