#include <stdio.h>
void printhelp() {
    printf("                       PhyloGibbs\n");
    printf("\n");
    printf("Algorithm development and code copyright (C) 2005 by\n");
    printf("    Rahul Siddharthan <rsidd@imsc.res.in> \n");
    printf("       (The Institute of Mathematical Sciences, Chennai, India)\n");
    printf("    Eric D. Siggia <siggia@eds1.rockefeller.edu>\n");
    printf("       (The Rockefeller University, New York, USA)\n");
    printf("    Erik van Nimwegen <erik.vannimwegen@unibas.ch>\n");
    printf("       (Biozentrum, University of Basel, and\n");
    printf("	Swiss Institute of Bioinformatics, Switzerland)\n");
    printf("\n");
    printf("Redistribution permitted under the terms of the GNU General Public\n");
    printf("License (see file COPYING in source distribution).\n");
    printf("\n");
    printf("Please send all questions and bugreports to Erik van Nimwegen <erik.vannimwegen@unibas.ch>.\n");
    printf("\n");
    printf("This is a quick summary of usage options.  For details, see the\n");
    printf("phylogibbs(1) and phylogibbs_algorithm(7) manpages (included with the\n");
    printf("source code as phylogibbs.1 and phylogibbs_algorithm.7).\n");
    printf("\n");
    printf("Quick start (phylogenetically unrelated sequences): \n");
    printf("  phylogibbs -D 0 -m motifwidth [-z number of motifs] [-y total number of sites in all motifs] -f input_seqfile\n");
    printf("Quick start (with phylogenetically related sequences):\n");
    printf("  phylogibbs [-D 1] -L Newick formatted tree -m motifwidth [-z number of motifs] [-y total number of sites in all motifs] -f input_seqfile\n");
    printf("\n");
    printf("Commonly used command-line options:\n");
    printf("-c, --ncolmoves n : do n colour-change moves per cycle (-1 = autoselect n) default 0.\n");
    printf("-D, --dialign n : (n=0) No alignment; (n=1) Loose align; (n=2) Strict align.\n");
    printf("-F, --bgfile filename : Read background sequence from filename.\n");
    printf("-f, --inputfile filename : Read input fasta sequence from filename.\n");
    printf("-L, --labeltree treestring: Specifies the phylogenetic tree for the species from which\n");
    printf("      the input sequences derive.\n");
    printf("-m, --motifwidth n : Search for motifs of width m.\n");
    printf("-M, --motiffile filename : File with external WMs to act as \"seeds\".\n");
    printf("-N, --ncorrel n : Order of the Markov chain for the background model. \n");
    printf("      (n-site, n=-1 = 0.25 each,n=0 no correlations with neighbors, n>0 n nearest\n");
    printf("      neighbors.)\n");
    printf("-o, --outputfile filename : Write anneal snapshots to filename\n");
    printf("-q, --quiet : Run quietly, no screen output\n");
    printf("-R, --reverseprint : Print (negative) position backwards from end of sequence.\n");
    printf("      Useful when end of sequence corresponds to transcription start.\n");
    printf("-r, --norevcomp : Search for motifs only on one strand. For instance when running\n");
    printf("      on RNA sequences. \n");
    printf("-S, --ncycles n : Do n cycles of the tracking phase. Sets running time.\n");
    printf("-t, --trackedoutput filename : Write tracking statistics to filename\n");
    printf("-y, --nexpwin num : Sets total number of sites. Either fixed (when no colour-moves\n");
    printf("      or the expected number (maximal entropy prior).\n");
    printf("-z, --nexpcol num : Sets number of motifs. Upper bound when no colour-moves and\n");
    printf("      sets expected number otherwise (maximal entropy prior).\n");
    printf("\n");
    printf("\n");
    printf("Other command-line options:\n");
    printf("-A, --trackfile filename : Track labelled clusters specified in filename\n");
    printf("-a, --nanneal n : do n cycles of the simulated anneal phase.\n");
    printf("-B, --blockedfile filename : Read a list of blocked windows from filename\n");
    printf("-b, --beta value : set initial inverse temperature to value\n");
    printf("-C, --rcsymmetric : Search for reverse-complement-symmetric motifs\n");
    printf("-E, --trackingcutoff e: Cut-off (float) for printing tracking statistics\n");
    printf("-g, --ndeepquench n : do n cycles of the deep quench phase\n");
    printf("-h, --help : Print this quick help summary and exit\n");
    printf("-I, --initialocc list : n initial windows per colour, for n in list (comma-sep)\n");
    printf("-i, --initfile filename : Read initial window config from filename.\n");
    printf("-P, --bgpscount value : Weigh backgrnd model with pseudocount of 1-site freqs.\n");
    printf("-p, --chempot value : Use \"chemical potential\" of given value for new sites.\n");
    printf("-s, --nshiftmoves n : n global-shift moves per cycle\n");
    printf("-T, --pseudocount value : Use pseudocount for prior in weight-matrix integral.\n");
    printf("-u, --ntransient n : do n cycles of the transient equilibriation phase.\n");
    printf("-v, --verbose : verbose output.\n");
    printf("-W, --write-each-cycle: write output file and tracking file every cycle.\n");
    printf("-w, --nwinmoves n : n window-shift moves per cycle.\n");
    printf("-X, --noautotrack : Stop after anneal (don't autotrack annealed clusters).\n");
    printf("-x, --betaincr value : at each anneal cycle, add value to beta.\n");
    printf("\n");
}
