/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* $Id: recolourwindow.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ */

/* Erik van Nimwegen June 29 2005                             *
 * If we have prior WMs then we are no longer removing     *
 *  bins that correspond to prior WMs                      *
*/


#include <assert.h>
#include "interspecies.h"

void blankwindow(params *v, window *currwin) 
{
  int wincol1,nb,nc;
  GPtrArray *binwin1,*binwin2;
  window *currwin2;
  
  wincol1=currwin->colour;
  
  
  currwin->colour=0;
  for (nb=currwin->blockedwins->len-1; nb>=0; nb--) {
    currwin2=g_ptr_array_index(currwin->blockedwins,nb);
    g_ptr_array_remove_fast(currwin2->blockers,currwin);
    if (currwin2->blockers->len==0) {
      currwin2->blocked=0;
    }
  }
  
  binwin1=g_ptr_array_index((v->bin),0);
  g_ptr_array_add(binwin1,currwin);
  binwin1=g_ptr_array_index((v->bin),wincol1);
  g_ptr_array_remove_fast(binwin1,currwin);
  /***remove the bin if empty AND this is a color beyond colors corresponding 
      to the prior WMs*************/
  if (binwin1->len==0 && wincol1 > ((v->priorbinbase)->len)) {
    g_ptr_array_remove_index_fast((v->bin),wincol1);
    g_ptr_array_free(binwin1,TRUE);
    /**renumber the colors above current color***/
    for (nb=wincol1-1; nb<(v->bin)->len; nb++) {
      binwin2=g_ptr_array_index((v->bin),nb);
      for (nc=0; nc<binwin2->len; nc++) {
	currwin2=g_ptr_array_index(binwin2,nc);
	currwin2->colour=nb;
      }
    }
  }
  
}


/* Erik van Nimwegen June 29 2005 ***
 * we can now also have that the window * 
 * is the first in an exitsting colour  *
 * i.e. the newcolour can be empty *
 */ 

void colourwindow(params *v, onemove *trialmove) 
{
  int wincol1,wincol1p,nb,nc;
  window *currwin,*currwin2;
  GPtrArray *binwin1,*binwin2,*currblockers;
  
  wincol1=trialmove->newcolour;
  wincol1p=0;
    
  currwin=trialmove->win;
  binwin1=g_ptr_array_index((v->bin),0);
  
  /**existing colour***/
  if ((v->bin)->len > wincol1) 
    {
      binwin2=g_ptr_array_index((v->bin),wincol1);
      /*assert((binwin2->len) > 0);*/
    } 
  /***new colour****/
  else 
    {
      binwin2=g_ptr_array_new();
      g_ptr_array_add((v->bin),binwin2);
    }
  
  g_ptr_array_remove_fast(binwin1,currwin);
  
  /* Debugging assert, should not fail */
#ifdef DEBUG
  for (nc=0;nc<binwin1->len; nc++) 
    assert(g_ptr_array_index(binwin1,nc)!=currwin);
  for (nc=0;nc<binwin2->len; nc++) 
    assert(g_ptr_array_index(binwin2,nc)!=currwin);
#endif
  
  
  g_ptr_array_add(binwin2,currwin);
  /*if (wincol1<(v->bin)->len-2)*/
  /*assert((binwin2->len) > 1);*/
  
  currwin->colour=trialmove->newcolour;
  assert(currwin->colour<(v->bin)->len);
  currwin->dir=trialmove->dir;
  
  
  
  /* update blocked and blockers using blockedwins of the moved
   * window -- necessary since we moved window from colour 0 to
   * non-zero colour (if not, we'd have exited by now)
   */
  for (nb=0; nb<currwin->blockedwins->len; nb++) 
    {
      currwin2=g_ptr_array_index(currwin->blockedwins,nb);
      currblockers=currwin2->blockers;
      g_ptr_array_add(currblockers,currwin);
      currwin2->blocked=1;
      assert(currwin2->blockers->len>0);
    }
  
}
