/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/*
 * $Id: seq2nums.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $
 */

#include <glib.h>

int seq2nums(GString *seq, GArray **seqnums) {

    int n,b;
    if ((*seqnums)!=NULL)
        g_array_free((*seqnums),TRUE);
    *seqnums=g_array_new(TRUE,TRUE,sizeof(int));

    for (n=0; n<seq->len; n++) {
        switch (seq->str[n]) {
		case 'A': case 'a': b=0; break;
		case 'C': case 'c': b=1; break;
		case 'G': case 'g': b=2; break;
		case 'T': case 't': b=3; break;
		case 'S': case 's': b=4; break;
		case 'W': case 'w': b=5; break;
		case 'R': case 'r': b=6; break;
		case 'Y': case 'y': b=7; break;
		case 'M': case 'm': b=8; break;
		case 'K': case 'k': b=9; break;
		case 'B': case 'b': b=10; break;
		case 'D': case 'd': b=11; break;
		case 'H': case 'h': b=12; break;
		case 'V': case 'v': b=13; break;
		case 'N': case 'n': b=14; break;
		default: b=15;break;
        }
        g_array_append_val((*seqnums),b);
    }
    return 0;
}
