/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: windowscore.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include "math.h"
#include "interspecies.h"
#include "wminteg.h"

double windowscore(params *v,window *win) 
{
    double weight,wlog;

    double count[4],tcount[4];  /* A C G T */
    int pn,m,wincol,pnlimit;

    binbasecount *thisbinbase;
    GArray *onebinbase;
    GPtrArray *wincol1;
    GPtrArray *thispriorbinbase;

    weight=0.0;
    wlog=0.0;

    wincol=win->colour;
    wincol1=g_ptr_array_index((v->bin),wincol);

    if (wincol==0)
        return 1.0;


    if (v->rcsymm)
        pnlimit=(v->wwidth)/2;
    else
        pnlimit=(v->wwidth);

    for (pn=0; pn<pnlimit; pn++) 
      {
	if (v->rcsymm) 
	  {
	    onebinbase=g_ptr_array_index(win->basecount,v->wwidth-1-pn);
	    wlog=wlog+g_array_index(win->bgcount,double,v->wwidth-1-pn);
	    for (m=0; m<4; m++) 
	      count[m]=g_array_index(onebinbase,double,3-m);
	    onebinbase=g_ptr_array_index(win->basecount,pn);
	    wlog=wlog+g_array_index(win->bgcount,double,pn);
	    for (m=0; m<4; m++) 
	      count[m]=count[m]+g_array_index(onebinbase,double,m);
	    weight=weight/exp(wminteg(count[0],count[1],count[2],count[3]));
	  } 
	else /** no rcsym***/
	  {
	    if (win->dir) 
	      {
		onebinbase=g_ptr_array_index(win->basecount,v->wwidth-1-pn);
		wlog=wlog+g_array_index(win->bgcount,double,v->wwidth-1-pn);
		for (m=0; m<4; m++) 
		  count[m]=g_array_index(onebinbase,double,3-m);
	      }
	    else 
	      {
		onebinbase=g_ptr_array_index(win->basecount,pn);
		wlog=wlog+g_array_index(win->bgcount,double,pn);
		for (m=0; m<4; m++) 
		  count[m]=g_array_index(onebinbase,double,m);
	      }
	    
	    thisbinbase=g_ptr_array_index((v->binbase),wincol-1);
	    onebinbase=g_ptr_array_index(thisbinbase,pn);
	    for (m=0; m<4; m++) 
	      tcount[m]=g_array_index(onebinbase,double,m);
	    /***add the prior binbase if exists****/
	    if((v->priorbinbase)->len > wincol-1)
	      {
		thispriorbinbase = g_ptr_array_index(v->priorbinbase,wincol-1);
		onebinbase = g_ptr_array_index(thispriorbinbase,pn);
		for(m=0;m<4;++m)
		  {
		    tcount[m]+=g_array_index(onebinbase,double,m);
		  }
	      }
	    /** counts in bin without window ***/
	    weight += wminteg(tcount[0]-count[0],tcount[1]-count[1],tcount[2]-count[2],tcount[3]-count[3]);
	    /*** total counts in bin ****/
	    weight -= wminteg(tcount[0],tcount[1],tcount[2],tcount[3]);
	  }
      }
      
    return exp(weight+wlog);

}

