/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* $Id: base2num.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ */

int base2num(char *seqstr, int ncorrel) 
{
    int output;
    int multfactor;
    int i;
    int base;

    /**if single-base background then the array just has one member**/
    if (ncorrel==0)
        return 0;

    output=0;
    multfactor=1;

    if (ncorrel<0)        
        for (i=0; i>ncorrel; i--) {
            switch (seqstr[i-1]) {
            case 'A': case 'a':
                base=0;
                break;
            case 'C': case 'c':
                base=1;
                break;
            case 'G': case 'g':
                base=2;
                break;
            case 'T': case 't':
                base=3;
                break;
            default: /* adhoc solution for nonACGT bases */
                base=0;
                break;
            }
            output=output+base*multfactor;
            multfactor *= 4;
        }
    else
        for (i=0; i<ncorrel; i++) {
            switch (seqstr[i+1]) {
            case 'A': case 'a':
                base=3;
                break;
            case 'C': case 'c':
                base=2;
                break;
            case 'G': case 'g':
                base=1;
                break;
            case 'T': case 't':
                base=0;
                break;
            default: /* adhoc */
                base=3;
                break;
            }
            output=output+base*multfactor;
            multfactor *= 4;
        }

    return output;
}
