/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York, USA  *
 *   and at The Institute of Mathematical Sciences, Chennai, India    *
 *                                                                    *
 *   This code copyright (C) 2004-2006 Rahul Siddharthan              *
 *   Licensed under the GNU General Public License (see COPYING)      *
 *   For support and contact information, see the webpage:            *
 *             http://www.imsc.res.in/~rsidd/phylogibbs/              */

/* 
 * $Author: rsidd $  
 * $Date: 2006/03/27 18:44:20 $ 
 * $Id: checkwindow.c,v 1.3 2006/03/27 18:44:20 rsidd Exp $ 
 */


#include "interspecies.h"
#include <ctype.h>
#include <assert.h>

int checkwindow(int wwidth, window *win, GArray **seq)
{
	
	/*   Checks whether a window satisfies the dialign
	 *   constraints.  Basically, that means capital letters
	 *   should line up properly.
	 *
	 *   If not, rejects it.
	 *
     *   Strategy: for each pair of sequences, at each position, if
     *   both sequences have capital letters, check that it's
     *   consistent.
	 *
	 */

	int nseqs,winok,m,l,l2,currseq,currseq2,currpos,
		currpos2;
	int n2di,n2di2;
	dialignseq tempseq,tempseq2;
    char tc,*data,*data2;
	

	nseqs=win->seq->len;

	winok=1;

	/* check that it is ok to add the current window too, ie it
	   doesn't contain X's */
    for (l=0; l<win->seq->len; l++) {
        for (m=0; m<wwidth; m++) {
            /* check that the window width is what is required */
            if ((g_array_index(win->stop,int,l)
                 - g_array_index(win->start,int,l) + 1)!=wwidth) {
                winok=0;
                goto exit;
            }
			data=g_array_index(win->data,char*,l);
			tc=*(data+m);
            if ((tc=='x')||(tc=='X')) { /* all other illegal characters
                                           weeded out in readDialign.c */
				winok=0;
				goto exit;
			}
		}
	}
	
    if (nseqs==1) { /* Nothing more to check here */
        winok=1;
        goto exit;
    }
    
    
	for (l=0; l<nseqs; l++) {
		
		

		if (g_array_index(win->start,int,l)<0) {
			winok=0;
			goto exit;
		}

		if (nseqs > 1) {
			
			for (m=0; m<wwidth; m++) {
			
				currseq=g_array_index(win->seq,int,l);
				currpos=g_array_index(win->start,int,l)+m;

				
				tempseq=g_array_index(*seq,dialignseq,currseq);
				data=g_array_index(win->data,char*,l);
				
				n2di=g_array_index(tempseq.bare2di,int,currpos);
				
				for (l2=0; l2<nseqs; l2++) {

					if (l2==l)
						continue;
					currseq2= g_array_index(win->seq,int,l2);
					currpos2=g_array_index(win->start,int,l2)+m;
					tempseq2=g_array_index(*seq,dialignseq,currseq2);
					data2=g_array_index(win->data,char*,l2);
					if (currpos2 < 0 || (currpos2 >= tempseq2.barelength)) {
						winok=0;
						goto exit;
					} else {
						n2di2=g_array_index(tempseq2.bare2di,int,currpos2);
						if (((n2di2!=n2di) && (isupper(data2[m])) && (isupper(data[m])))
							|| ((g_array_index(tempseq.di2bare,int,n2di2)!=currpos)
								&& (isupper(data2[m])) && (isupper(g_array_index(tempseq.dialignseq,char,n2di2))))
							|| ((g_array_index(tempseq2.di2bare,int,n2di)!=currpos2)
								&& (isupper(data[m])) && (isupper(g_array_index(tempseq2.dialignseq,char,n2di))))) {
							winok=0;
							goto exit;
						}
					}
				}
			}
		}
	}
	
	


 exit:	
	return winok;
}
