/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: fullbinweight.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */




#include <math.h>

#include "interspecies.h"
#include "wminteg.h"
#include "binbasecount.h"
#include "binscore.h"

double fullbinweight(params *v) 
{
    double weightb;
    int n;

    weightb=0.0;

    makebinbasecount(v);

    for (n=0; n<(v->binbase)->len; n++) {
      weightb=weightb+binscore(v,n+1);
    }


   return weightb*(v->beta);
  
}

