/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: initbins.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include "interspecies.h"

/* The structure sorts windows into bins... for use by the gibbs
 * sampler.  Bins are ordered by colour, 0 (ie, window is free), 1,
 * 2... 
 *
 * bin->bins is a GPtrArray (array of pointers) each of which points
 * to a GPtrArray of windows.  Complicated but looked the most
 * flexible...
 *
 * This routine sets all colours to zero.
 *
 */

int initbins(params *v) 
{
    int n,l;
    window *thiswin;
    GPtrArray *thisbin;

    l=(v->win)->len;

    if (v->bin != NULL) {
        for (n=v->bin->len-1; n>=0; n--) {
            thisbin=g_ptr_array_index(v->bin,n);
            g_ptr_array_remove_index(v->bin,n);
            g_ptr_array_free(thisbin,TRUE);
        }
        g_ptr_array_free(v->bin,TRUE);
    }
    
    v->bin=g_ptr_array_new();
    thisbin=g_ptr_array_new();
    g_ptr_array_add(v->bin,thisbin);


    for (n=0; n<l; n++) {
        thiswin = &g_array_index(v->win,window,n);
        thiswin->colour=0;
        thiswin->blocked=0;
        thiswin->dir=0;
        
        g_ptr_array_free(thiswin->blockers,TRUE);
        thiswin->blockers=g_ptr_array_new();

        thisbin=g_ptr_array_index((v->bin),0);
        g_ptr_array_add(thisbin,thiswin);
    }
    return 0;

}

