/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/22 13:29:54 $ 
 * $Id: interspecies.h,v 1.4 2005/05/22 13:29:54 rsidd Exp $ 
 */


#include <glib.h>
#include <assert.h>
#include <gsl/gsl_rng.h>

/*  The dialignseq struct should contain whatever we need to know
 *  about one sequence, as output by dialign, for purposes of the
 *  gibbs sampling with holes etc.  In progress, try keep flexible.
 */

typedef struct {
  GString *name;          /*  Name of sequence, from fasta/dialign 
			   *  file */
  guint    barelength;    /* Length of sequence without gaps */
  guint    dialignlength; /* Length of dialign-output with gaps */
  GArray    *bareseq;     /* sequence without gaps or lowercases */
  GArray    *dialignseq;  /* Dialign sequence, maybe superfluous */
  GArray    *bare2di; /* position on bare -> position on aligned */
  GArray    *di2bare; /* position on bare -> position on aligned */
} dialignseq;


typedef struct {
    GArray *seq,*species,*start,*stop,*data;
    int dir, /* FALSE=forward, TRUE=reverse (+complement) */
            blocked, /* FALSE=open, TRUE=blocked, ie something else is 
                blocking it) */
           shiftblocked, /* keep track of whether this shift move would
                         block this window... necessary with rc moves */
            permblocked; /* this window is blocked forever: useful if
                            it's already been "selected" earlier
                            as a binding site */
    guint  colour; /* 0 = window not taken yet, 1, 2, 3 = different
              transcription factor */
    GPtrArray *blockedwins, /* windows that are blocked by this one */
           *blockers;  /* windows that block this one */
    GPtrArray *left, *right; /* each element gives window to the left, 
                         * and to the right, of this one, for global 
                         * shift moves and other stuff; length
                         * wwidth/2; set to NULL if no legal shifted
                         * window there
                         */
  GPtrArray *basecount; 
               /* each element points to a GArray of 4 doubles 
		  indicating counts for A, C, G, T */
  GArray *bgcount; /* each element is log(prob(base)^count(base)) 
                                  where count is the above basecount */
  double occ;
  GArray *trackedocc;
  GArray *trackedrev;
} window;

typedef struct {
  char seqfile[256];
  int wwidth;
  int usedialign;
  int usedir;
  double beta;
  double betaincr;
  double mu;
  double lambda;
  int deswin;
  int descol;
  int numtfs; /**how many other WMs there are (used when using motiffile) ****/
  int Ncolm;
  int Nwinm;
  int Nshiftm;
  char posfile[256];
  char blockedfile[256];
  char outfile[256];
  char trackedprintfile[256];
  char trackedbinfile[256];
  char bgfile[256];
  char motiffile[256];
  char arguments[1024];
  int gethelp;
  GArray *occset;
  GArray *seqmuset;
  double nomutprob;
  double trackingcutoff;
  int nbgc;
  double meanent;
  long int countent;
  long int totaliters;
  long int transientiters;
  long int annealiters;
  long int deepquenchiters;
  double pseudocount;
  int rcsymm;
  int quiet;
  int verbose;
  int writeatend;
  int printreverse;
  double iterthres;
  long int tcsteps,twsteps,tssteps,tmsteps,totmoves;
  long int seed;
  GArray *givenbgcounts;
  int autotrack;
  double bgpscount;
  GArray *win;
  GPtrArray *bin;
  GPtrArray *trackedbins;
  GPtrArray *trackeddirs;
  /**base counts in current colors****/
  GPtrArray *binbase;
  /***prior base counts in a number of colors***/
  GPtrArray *priorbinbase;
  /***names corresponding to the motifs***/
  GPtrArray *priorbinname;
  GPtrArray *labels;
  GArray *priors;
  GArray *binnums;
  GArray *seqarray;
  GArray *seqgroups;
  GArray *groupstarts; /**pointer to first window in each group of sequences****/
  GPtrArray *seqwin;
  GArray *fseqs;
  GArray *bgseqs;
  GPtrArray *bgcount,*rawbgcount;
  gsl_rng *gslrand;
  GNode *labeltree;
} params;



typedef struct {
    window *win, *pairwin;
    int dir, pairdir;
    int oldcolour,oldpaircolour, newcolour,newpaircolour,oldnumber;
    double moveweight,penalty;
    } onemove;

typedef struct {
    int bin;
    GPtrArray *newbin;
  double moveweight;
    } oneshiftmove;

typedef GPtrArray binbasecount;

typedef GPtrArray binbasecountset;

#define bincount(binset,index) ((*(GPtrArray *)g_ptr_array_index((binset),index)).len)  /* counts the number of windows in a given bin (colour) */

#define ncolours(binset) ((*(GPtrArray *)(binset)).len) 
    /* counts the number of different colours */

#define binwinset(binset,col) ((GPtrArray *)g_ptr_array_index(binset,col))
#define binwindow(binwinset,win) ((window *)g_ptr_array_index(binwinset, win))


