/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: makebinbasecount.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */


/* Erik June 29 2005
 * now also count colors without windows in it *
*/

#include "interspecies.h"



int binbasecountremove(params *v, int index) 
{

    binbasecount *thisbinbase;
    GArray *onebinbase;
    int m,mlimit;

    thisbinbase=g_ptr_array_index((v->binbase),index);
    if (v->rcsymm)
        mlimit=(v->wwidth)/2;
    else
        mlimit= v->wwidth;
    for (m=0; m<mlimit; m++) {
        onebinbase=g_ptr_array_index(thisbinbase,m);
        g_array_free(onebinbase,TRUE);
    }

    g_ptr_array_free(thisbinbase,TRUE);
    g_ptr_array_remove_index_fast((v->binbase),index);

    return 0;

}



int makebinbasecount(params *v) 
{
	int n,m,l,q,nlimit;
    GPtrArray *winbin1;
    window *tempwin1;
    binbasecount *thisbinbase;
    GArray *onebinbase, *winbinbase;
    double count[4];

    /***remove old column counts of all colours**/
    if ((v->binbase) != NULL) {
        for (m=(v->binbase)->len-1; m>=0; m--)
            binbasecountremove(v,m);
        g_ptr_array_free((v->binbase),TRUE);
    }

    (v->binbase)=g_ptr_array_new();

#ifdef DEBUG
    winbin1=g_ptr_array_index((v->bin),0);
    for (n=0; n<winbin1->len; n++) {
        tempwin1=g_ptr_array_index(winbin1,n);
        assert(tempwin1->colour==0);
        assert(!tempwin1->shiftblocked);
    }
#endif

    /**run over all colors***/
    for (m=1; m<(v->bin)->len; m++) {
      /**list of windows in this color**/
        winbin1=g_ptr_array_index((v->bin),m);
        /* assert(winbin1->len>0);*/
	/***an ptr array for the base counts of this color***/
        thisbinbase=g_ptr_array_new();
        if (v->rcsymm)
            nlimit=(v->wwidth)/2;
        else
            nlimit= v->wwidth;
	/**run over all columns**/
        for (n=0; n<nlimit; n++) {
            count[0]=0.0;
            count[1]=0.0;
            count[2]=0.0;
            count[3]=0.0;
	    /**run over all windows in color***/
            for (l=0; l<winbin1->len; l++) {
                tempwin1=g_ptr_array_index(winbin1,l);
                assert(!tempwin1->blocked);
                assert(!tempwin1->shiftblocked);
                assert(tempwin1->colour==m);
                if (v->rcsymm) {
                    winbinbase=g_ptr_array_index(tempwin1->basecount,v->wwidth-1-n);
                    for (q=0; q<4; q++)
                        count[q]=count[q]+g_array_index(winbinbase,double,3-q);
                    winbinbase=g_ptr_array_index(tempwin1->basecount,n);
                    for (q=0; q<4; q++)
                        count[q]=count[q]+g_array_index(winbinbase,double,q);
                } else {
                    if (tempwin1->dir)
		      {
			winbinbase=g_ptr_array_index(tempwin1->basecount,v->wwidth-1-n);
			for (q=0; q<4; q++)
			  count[q]=count[q]+g_array_index(winbinbase,double,3-q);
		      }
                    else
		      {
			winbinbase=g_ptr_array_index(tempwin1->basecount,n);
			for (q=0; q<4; q++)
			  count[q]=count[q]+g_array_index(winbinbase,double,q);
		      }
                }
            }
	    /**an array with base countss for this column of this color***/
            onebinbase=g_array_new(TRUE,TRUE,sizeof(double));
            g_array_append_val(onebinbase,(count[0]));
            g_array_append_val(onebinbase,(count[1]));
            g_array_append_val(onebinbase,(count[2]));
            g_array_append_val(onebinbase,(count[3]));
	    /***add column to counts for this color***/
            g_ptr_array_add(thisbinbase,onebinbase);
        }
	/***add color to colors****/
        g_ptr_array_add((v->binbase),thisbinbase);
    }

    return 0;
}
