/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: moveweight.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include <math.h>
#include "interspecies.h"
#include "wminteg.h"
#include "binbasecount.h"

/* This function calculates the change in log-score
 * from a state with a given window blank 
 * to a given window with the new color */


double moveweight(params *v,onemove *trialmove)
{
    double weight1,totalcount,wlog,testweight1;
    double tcount[4];  /* A C G T */
    double count[4];
    unsigned int pn,n,m,oldcol,newcol,countone,pnlimit;
    
    GPtrArray *thisbinbase;
    GPtrArray *thispriorbinbase;
    GArray *onebinbase;
    window *wintmp1;
    
    oldcol=trialmove->oldcolour;
    newcol=trialmove->newcolour;
    wintmp1=trialmove->win;
    
#ifdef DEBUG
    assert(oldcol==0);
#endif
    if (oldcol==newcol)
        return 0.0;
    
    weight1=0.0;
    wlog=0.0;
    
    if (v->rcsymm)
        pnlimit=v->wwidth/2;
    else
        pnlimit=v->wwidth;
    
    /***run over all columns**/
    for (pn=0; pn<pnlimit; ++pn) 
      {
	if (v->rcsymm) 
	  {
	    countone=1;
	    wlog=wlog-g_array_index(wintmp1->bgcount,double,v->wwidth-1-pn);
	    onebinbase = g_ptr_array_index(wintmp1->basecount,v->wwidth-1-pn);
	    for (m=0;m<4;++m)
	      count[m]=g_array_index(onebinbase,double,3-m);
	    wlog=wlog-g_array_index(wintmp1->bgcount,double,pn);
	    onebinbase=g_ptr_array_index(wintmp1->basecount,pn);
	    for (m=0;m<4;++m) {
	      count[m]=count[m]+g_array_index(onebinbase,double,m);
	      if ((count[m]!=1.0)&&(count[m]!=0.0))
		countone=0;
	    }
	  } 
	else 
	  {
	    /**set wlog to negative background weight***/
	    /**and onebinbase to counts this column of window***/
	    /* if every count[n] = 1.0 or 0.0, a quick calculation of
	     * the update is possible.  Otherwise, do the full, dirty
	     * calculation.
	     */
	    countone = 1;
	    if (wintmp1->dir) 
	      {
		wlog=wlog-g_array_index(wintmp1->bgcount,double,v->wwidth-1-pn);
		onebinbase=g_ptr_array_index(wintmp1->basecount,v->wwidth-1-pn);
		for (m=0;m<4;++m) 
		  {
		    count[m]=g_array_index(onebinbase,double,3-m);
		    if ((count[m]!=1.0)&&(count[m]!=0.0))
		      countone=0;
		  }
	      } 
	    else 
	      {
		wlog=wlog-g_array_index(wintmp1->bgcount,double,pn);
		onebinbase=g_ptr_array_index(wintmp1->basecount,pn);
		for (m=0;m<4;++m) 
		  {
		    count[m]=g_array_index(onebinbase,double,m);
		    if ((count[m]!=1.0)&&(count[m]!=0.0))
		      countone=0;
		  }
	      }
	  }
            
	/* newcol must be > 0, otherwise we'd have exited by now */
	if (newcol<(v->bin)->len) {
	  thisbinbase=g_ptr_array_index((v->binbase),newcol-1);
	  onebinbase=g_ptr_array_index(thisbinbase,pn);
	  /**get base counts in window***/
	  for (n=0;n<4;++n) 
	    {
	      tcount[n]=g_array_index(onebinbase,double,n);
	    }
	  /***add the prior counts if they exist***/
	  if((v->priorbinbase)->len > newcol-1)
	    {
	      thispriorbinbase = g_ptr_array_index(v->priorbinbase,newcol-1);
	      onebinbase = g_ptr_array_index(thispriorbinbase,pn);
	      for(n=0;n<4;++n)
		{
		  tcount[n]+=g_array_index(onebinbase,double,n);
		}
	    }
	  if (countone) 
	    {
	      testweight1 = 1;
	      totalcount = 0;
	      for(m=0;m<4;++m)
		{
		  totalcount += tcount[m];
		}
	      for (m=0;m<4;++m) 
		{
		  if ( count[m] !=0.0) 
		    {
		      testweight1*=((tcount[m]+g_array_index((v->priors),double,m))/(totalcount+g_array_index((v->priors),double,4)));
		      ++totalcount;
		    }
		}
	      weight1 += log(testweight1);
	    }
	  else 
	    {
	      weight1 +=  wminteg(tcount[0]+count[0],tcount[1]+count[1],tcount[2]+count[2],tcount[3]+count[3]);
	      weight1 -= wminteg(tcount[0],tcount[1],tcount[2],tcount[3]);
	    }
	}
	/****new colour***/
	else 
	  {
	    /**check if this color has a prior count***/
	    if((v->priorbinbase)->len > newcol-1)
	      {
		thispriorbinbase = g_ptr_array_index(v->priorbinbase,newcol-1);
		onebinbase = g_ptr_array_index(thispriorbinbase,pn);
		for(n=0;n<4;++n)
		  {
		    tcount[n]+=g_array_index(onebinbase,double,n);
		  }
		weight1 +=  wminteg(tcount[0]+count[0],tcount[1]+count[1],tcount[2]+count[2],tcount[3]+count[3]);
		weight1 -= wminteg(tcount[0],tcount[1],tcount[2],tcount[3]);
	      }
	    /**zero count for this color****/
	    else
	      {
		weight1 += wminteg(count[0],count[1],count[2],count[3]);
	      }
	  }
      }
        
    return weight1+wlog;
    
}

