/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: updatetracked.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include "interspecies.h"
#include "windowscore.h"

/* 
 * Updates the tracked bins as input originally; do this only if
 * trackedbins != NULL The idea is, for each tracked bin:
 *
 *    o  Check which of the current bins has the best score (combined
 *       1/windowscores) of members from this tracked bin, considering also
 *       shifts (with each shift equal).  Treat that as the ``image'' of
 *       this tracked bin.  Unlikely to be degeneracy, so ignore the
 *       possibility (if it happens, the first will be picked
 *       arbitrarily).
 *  
 *    o  note: windowscore = prob of being in bin rather than being
 *       out and is small for good windows.  We want a number that 
 *       is large for good windows, and gets larger as we add more 
 *       good windows, and is outcompeted by a few good windows as 
 *       opposed to lots of not so good windows.  Hence, use 
 *       sum 1/windowscore.
 *
 *    o  For each window check whether it's in one of the "image" bins
 *       of the set of tracked bins; if so, increment the corresponding
 *       element of trackedocc.
 *
 *                  **************************************
 *
 *    o  In case of dimers: assume the tracked bin is only one half of
 *       the dimer, the other half is in ->trackedpartner for each
 *       window.  Assume also the tracked bin is even-numbered
 *       (odd-numbered trackedbins are set to NULL), so scan
 *       only odd-numbered bins for matches, with partners in
 *       corresponding even-numbered bins.  (if NULL, ignore partners.)
 *       Match pairs thus, and continue as in non-dimer case.
 *
 */

#define wshift(win,n) \
    (((((window *) win)->dir == 0) && (n<0)) \
     || ((((window *)win)->dir > 0) && (n>0))) \
            ? (window *) g_ptr_array_index(((window *)(win))->left,((n<0) ? -n : n)-1) \
            : (window *) g_ptr_array_index(((window *)(win))->right,((n<0) ? -n : n)-1)


int updatetracked(params *v) 
{
    GPtrArray *thisbin,*thistrackedbin;
    GArray *thistrackeddir;
    window *thiswin,*thiswin2, *refwin;
    int bestscore,thisscore,dirscore;
    int n,m,s,n2,n3,smax,thisshift;
    int imagebin,shift,bestdir,refdir,thisdir;
    
    smax=v->wwidth/2;
    
    /**run over all reference clusters****/
    for (n=0; n<(v->trackedbins)->len; n++) 
      {
        thistrackedbin=g_ptr_array_index((v->trackedbins),n);
	thistrackeddir=g_ptr_array_index((v->trackeddirs),n);
        bestscore=0.0;
	bestdir = 0;
        imagebin = 0;
        shift = 0;
        /**run over current colors*****/
        for (m=1; m<(v->bin)->len; m++) 
	  {
            thisbin=g_ptr_array_index((v->bin),m);
            for (s=-smax; s<=smax; s++) 
	      {
                thisscore=0;
		dirscore = 0;
                for (n2=0; n2<thistrackedbin->len; n2++) 
		  {
		    refwin = (window *)g_ptr_array_index(thistrackedbin,n2);
		    refdir = g_array_index(thistrackeddir,int,n2);
                    for (n3=0; n3<thisbin->len; n3++) 
		      {
			thiswin2 = g_ptr_array_index(thisbin,n3);
			thisdir = thiswin2->dir;
                        if (s==0)  /* no shift */
			  thiswin=thiswin2;
                        else  /* shift, <0 = left, >0 = right */
			  thiswin=wshift(thiswin2,s);
                        if (thiswin==refwin) 
			  {
			    if(s>=0) 
			      {
				thisscore += (v->wwidth-s);
				if(thisdir == refdir)
				  dirscore += (v->wwidth-s);
				else
				  dirscore -= (v->wwidth-s);
			      }
			    else 
			      {
				thisscore += (v->wwidth+s);
				if(thisdir == refdir)
                                  dirscore += (v->wwidth+s);
                                else
                                  dirscore -= (v->wwidth+s);
			      }
			  }
		      }
		  }
                if (thisscore>bestscore) 
		  {
                    bestscore=thisscore;
                    imagebin=m;
                    shift=s;
		    if(dirscore >= 0)
		      bestdir = 0;
		    else
		      bestdir = 1;
		  }
	      }
	  }
        /***update properly shifted versions of the windows in the image***/
        if (imagebin>0) 
	  {
	    /***get image color***/
	    thisbin=g_ptr_array_index((v->bin),imagebin);
	    thisshift=shift;
	    /**go through all windows in bin and shift onto ref cluster***/
	    for (n3=0; n3<thisbin->len; n3++) 
	      {
		thiswin2=g_ptr_array_index(thisbin,n3);
		thisdir = thiswin2->dir;
		if (thisshift!=0)
		  thiswin2=wshift(thiswin2,thisshift);
		/**check this window exists***/
		if(thiswin2 != NULL) 
		  {
		    /**check that trackedocc is initialized and has enough elements**/
		    if (thiswin2->trackedocc==NULL)
		      {
			thiswin2->trackedocc=g_array_new(TRUE,TRUE,sizeof(int));
			thiswin2->trackedrev=g_array_new(TRUE,TRUE,sizeof(int));
			s = 0;
			while(thiswin2->trackedocc->len < (v->trackedbins)->len)
			  {
			    g_array_append_val(thiswin2->trackedocc,s);
			    g_array_append_val(thiswin2->trackedrev,s);
			  }
		      }
		    else
		      {
			if(thiswin2->trackedocc->len < (v->trackedbins)->len)
			  {
			    fprintf(stderr,"ERROR trackedocc initialized but length %d instead of %d\n",thiswin2->trackedocc->len,(v->trackedbins)->len);
			  }
			s = 0;
			while(thiswin2->trackedocc->len < (v->trackedbins)->len)
			  {
			    g_array_append_val(thiswin2->trackedocc,s);
			    g_array_append_val(thiswin2->trackedrev,s);
			  }
		      }
		    /**update tracked count****/
		    g_array_index(thiswin2->trackedocc,int,n) += 1;
		    /**check if the window is entering reversed in this round****/
		    if(thisdir != bestdir)
		      {
			g_array_index(thiswin2->trackedrev,int,n) += 1;
		      }
		  }
	      }
	  }
      }
    /*free(updatedwin);*/
    return 0;
}
