#include <math.h>
#include "log_gamma.h"

double log_gamma(double x)
{
	return log(2.5066282746310005 *
			(1.000000000190015 +
				76.18009172947146 / (x + 1) -
				86.50532032941677 / (x + 2) +
				24.01409824083091 / (x + 3) -
				1.231739572460166 / (x + 4) +
				0.001208650973866179 / (x + 5) -
				0.000005395239384953 / (x + 6)
			) / x) + (x + 0.5) * log(x + 5.5) - x - 5.5;
}
