#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <limits.h>
#include <float.h>
#include <string.h>
#include <time.h>
#include "procse_ReVector.h"
#include "procse_random.h"

/* Log Cache */
class LC
{
	static int size;
	static double *cache;
	LC(); /* no default constructor */
public:
	static void configure(int cachesize); 
	static void destroy();
	static const double &log(int x) {return cache[x];}
};

/* Log Gamma (Normalized) Caches */
class LGNC
{
	static int size;
	static double *cache_q;
	static double *cache_4q;
	LGNC(); /* no default constructor */
public:
	static void configure(int cachesize, double q); 
	static void destroy();
	static const double &lgnorq(int x) {return cache_q[x];}
	static const double &lgnor4q(int x) {return cache_4q[x];}
};

struct MainParameters
{
	enum {MAX_WORD_LEN = 100};			/* param name & val - for parsing */
	enum ParameterType {PT_INT, PT_DOUBLE, PT_STRING, PT_BOOL};
	enum {MAX_FILENAME_PREFIX_LEN = 100};
	enum RecordType {RT_NULL = 0, RT_SIGNIFICANCE = 1, RT_PAIRWISE = 2};
	enum StateEntropyMethod {EM_PLAIN = 0, EM_RANDOM = 1};
	enum StateSizeAdjust {SA_NONE = 0, SA_COUNT = 1, SA_COUNT_AND_SIZE = 2};
	/* general parameters */
	int random_seed;
	double q;					/* used for log gamma cache init */
	int aw_len;					/* REQUIRED: alignment window length */
	int initial_cluster_size;			/* start state cluster size */
	/* type of run */
	RecordType record_type;				/* statistics to keep: none, sig, pair */
	StateEntropyMethod entropy_method;		/* Plain or Random_column */
	StateSizeAdjust sizeadj;			/* cluster count/size prior adjustment */
	double chemical_potential;			/* chemical potential for tuning size adjustment*/
	double coherent_shift_period;			/* timesteps between coherent shift */
	/* temperature clock parameters */
	double transient_beta;
	double final_beta;
	double total_time_steps;			/* REQUIRED: steps to get to reference */
	double transient_time_steps;			/* lenth of transient */
	double deep_quench_time_steps;			/* length of deep_quench */
	double significance_run_total_time_steps;	/* second pass of RT_SIGNIFICANCE */
	/* record keeping and output parameters */
	char filename_prefix[MAX_FILENAME_PREFIX_LEN];	/* added before all output filenames */
	long int log_dump_period;			/* seconds between log dumps of state */
	double significance_sample_period;		/* timesteps in 2nd pass of RT_SIGNIFICANCE */
	double sig_min_pair_presence;			/* filters reference clusters in RT_SIG.... */
	double cluster_member_sig_cutoff;		/* truncates membership lists (SIG&PAIR) */
	bool verbose;					/* state dumps show TGA distributions? */
  bool single_strand;
	double pseudocluster_cutoff;			/* connectivity threshold in RT_PAIRWISE */
	MainParameters();				/* constructor */
	static const char * const pname[];		/* parameter names */
};

