/* ReVector is a Resizeable Vector container class
	meant for efficient reuse of dynamically allocated
	memory. Resizing is accomplished with the "grow"
	member function - new memory is allocated only if
	needed - otherwise old memory is re-used. Contents
	are not copied upon reallocation, so "grow" may
	invalidate the contents of the vector. Also,
	allocated memory never shrinks until destruction.
*/

template <class T>
class ReVector
{
	int size;
	T *vector;
	ReVector(const ReVector &);		/* no copy constructor */
	ReVector &operator=(const ReVector &);	/* no assignment */
public:
	ReVector(int a_size = 1) : size(a_size) {vector = new T[size];}
	~ReVector() {delete[] vector;}
	inline void grow(int new_size) {
		if (new_size > size) {
			delete[] vector;
			vector = new T[new_size];
			size = new_size;
		}
	}
	const T &read(int pos) const {return vector[pos];}
	T &operator[](int pos) const {return vector[pos];}
};
