extern double get_column_score_beta_global;

template <class mcmState, class mcmMoveSet, class mcmTemp, class mcmRecord>
void monte_carlo_markov(mcmState *state, mcmTemp *tempclock, mcmRecord *record)
{
	ReVector<double> probability(1);
	while (!tempclock->done()) {
		get_column_score_beta_global = tempclock->get_beta();
		mcmMoveSet *moveset = state->propose_moveset();
		{
			const double *neglogpostprob = moveset->get_neglogpostprob();
			/* make sure probability vector is big enough */
			const int num_moves = moveset->get_num_moves();
			probability.grow(num_moves);
			/* shift neglogpostprob range to 0.0 (to avoid numerical limit) */
			double neglogpostprob_min = DBL_MAX;
			int move;
			for (move = 0; move<num_moves; move++) {
				double nlpp = neglogpostprob[move];
				if (nlpp < neglogpostprob_min) neglogpostprob_min = nlpp;
			}
			/* calculate and total probabilities */
			double total_probability = 0.0;
			for (move = 0; move<num_moves; move++) {
				double prob = exp(-tempclock->get_beta() *
						(neglogpostprob[move] - neglogpostprob_min));
				probability[move] = prob;
				total_probability += prob;
			}
			/* select move */
			double p = double_ranged_rand(total_probability);
			int take_move = 0;
			while (p >= 0 && take_move < num_moves) p -= probability[take_move++];
			moveset->apply(take_move - 1);
		}
		record->update(state,tempclock->get_time());
		tempclock->step();
	}
	record->finalize_reference();
}
