/* Source code courtesy of Jeffery D. Taft, PhD. */
/* http://www.nauticom.net/www/jdtaft/ */
/* modified and adapted 2003 */

void tri_diagonalize(double *Cxd, double *d,double *e, double *A, int L, double tol);

int calc_eigenstructure(double *d, double *e, double *A, int L, double macheps);

/* tri_diagonalize() is called first to convert a real symmetric matrix
to tri-diagonal form. Then calc_eigenstructure() is called to generate a
matrix of eigenvectors, sorted in decending order of eigenvalue magnitude. */

/* arguments:
tri_diagonalize( Cxd, d, e, A, L, tol) 
Cxd - an LxL sized matrix containing the symmetric matrix to be analyzed, 
      such as a covariance matrix
d -   a length L vector that passes results to the next routine;
      needs no initialization 
e -   a length L vector that passes results to the next routine;
      needs no initialization 
A -   an LxL matrix that holds the tri-diagonalized version of Cxd upon return; 
      needed to pass to the next routine; needs no initialization 
tol - tolerance for checking nearness to zero; Suggested: 1.0e-6
*/

/*
calc_eigenstructure( d, e, A, L, macheps ) 
d - vector as above; on return it holds the eigenvalues in sorted order (smallest to largest) 
e - vector as above; used to pass info into this routine from the previous one 
A - matrix as above; on return it holds the array of eigenvectors as columns in order 
      corresponding to the eigenvalues in d 
macheps - an iteration error tolerance parameter; Suggested: 1.0e-16

*/
