#include "locusList.h"

void locusInit ( locusList *locus ) {
  locus->size = 0;
  locus->head = NULL;
  locus->tail = NULL;
  return;
}



int locusAdd ( locusList *locus, locusElem *elem, char *chrName, int start, int end, int score ) {

  locusElem *new_locus;
  if ((new_locus = (locusElem *)malloc(sizeof(locusElem))) == NULL ) {
    printf ("ERROR\n");
    return -1;
  }

  strncpy(new_locus->chrName, chrName, 128);
  new_locus->chrName[127] = '\0';
  new_locus->start = start;
  new_locus->end = end;
  new_locus->score = score;

  /*printf("chrName = %s  start = %d  end = %d  score = %d\n", 
          new_locus->chrName, new_locus->start, new_locus->end, new_locus->score);
  */
  if ( elem == NULL ) {
    if ( locus->size == 0 ) 
      locus->tail = new_locus;
    new_locus->next = locus->head;
    locus->head = new_locus;
  }
  else {
    if ( elem->next == NULL )
      locus->tail = new_locus;
    
    new_locus->next = elem->next;
    elem->next = new_locus;
  }
  locus->size++;
  return 0;

}

int locusFree ( locusList *locus ) {
  while ( locus->size > 0 ) {
    locusRemNext( locus,  NULL );
  }
  return 0;
}

int locusRemNext ( locusList *locus, locusElem *elem ) {
  locusElem *old_elem;
  if ( locus->size == 0 )
    return -1;

  if ( elem == NULL ) {
    old_elem = locus->head;
    locus->head = locus->head->next;
    if ( locus->size == 1 ) 
      locus->tail == NULL;
  }
  else {
    if ( elem->next == NULL )
      return -1;

    old_elem = elem->next;
    elem->next = elem->next->next;

    if ( elem->next == NULL )
      locus->tail = elem;
  }
  free(old_elem);
  locus->size--;
  return 0;
}
