/* repMask.c was originally generated by the autoSql program, which also 
 * generated repMask.h and repMask.sql.  This module links the database and the RAM 
 * representation of objects. */

#include "common.h"
#include "sqlList.h"
#include "sqlNum.h"
#include "repMask.h"

void repeatMaskOutStaticLoad(char **row, struct repeatMaskOut *ret)
/* Load a row from repeatMaskOut table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->score = sqlUnsigned(row[0]);
ret->percDiv = atof(row[1]);
ret->percDel = atof(row[2]);
ret->percInc = atof(row[3]);
ret->qName = row[4];
ret->qStart = sqlSigned(row[5]);
ret->qEnd = sqlSigned(row[6]);
ret->qLeft = row[7];
strcpy(ret->strand, row[8]);
ret->rName = row[9];
ret->rFamily = row[10];
ret->rStart = row[11];
ret->rEnd = sqlUnsigned(row[12]);
ret->rLeft = row[13];
}

struct repeatMaskOut *repeatMaskOutLoad(char **row)
/* Load a repeatMaskOut from row fetched with select * from repeatMaskOut
 * from database.  Dispose of this with repeatMaskOutFree(). */
{
struct repeatMaskOut *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->score = sqlUnsigned(row[0]);
ret->percDiv = atof(row[1]);
ret->percDel = atof(row[2]);
ret->percInc = atof(row[3]);
ret->qName = cloneString(row[4]);
ret->qStart = sqlSigned(row[5]);
ret->qEnd = sqlSigned(row[6]);
ret->qLeft = cloneString(row[7]);
strcpy(ret->strand, row[8]);
ret->rName = cloneString(row[9]);
ret->rFamily = cloneString(row[10]);
ret->rStart = cloneString(row[11]);
ret->rEnd = sqlUnsigned(row[12]);
ret->rLeft = cloneString(row[13]);
return ret;
}

struct repeatMaskOut *repeatMaskOutCommaIn(char **pS)
/* Create a repeatMaskOut out of a comma separated string. */
{
struct repeatMaskOut *ret;
char *s = *pS;
int i;

AllocVar(ret);
ret->score = sqlUnsignedComma(&s);
ret->percDiv = sqlSignedComma(&s);
ret->percDel = sqlSignedComma(&s);
ret->percInc = sqlSignedComma(&s);
ret->qName = sqlStringComma(&s);
ret->qStart = sqlSignedComma(&s);
ret->qEnd = sqlSignedComma(&s);
ret->qLeft = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->rName = sqlStringComma(&s);
ret->rFamily = sqlStringComma(&s);
ret->rStart = sqlStringComma(&s);
ret->rEnd = sqlUnsignedComma(&s);
ret->rLeft = sqlStringComma(&s);
*pS = s;
return ret;
}

void repeatMaskOutFree(struct repeatMaskOut **pEl)
/* Free a single dynamically allocated repeatMaskOut such as created
 * with repeatMaskOutLoad(). */
{
struct repeatMaskOut *el;

if ((el = *pEl) == NULL) return;
freeMem(el->qName);
freeMem(el->qLeft);
freeMem(el->rName);
freeMem(el->rFamily);
freeMem(el->rStart);
freeMem(el->rLeft);
freez(pEl);
}

void repeatMaskOutFreeList(struct repeatMaskOut **pList)
/* Free a list of dynamically allocated repeatMaskOut's */
{
struct repeatMaskOut *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    repeatMaskOutFree(&el);
    }
*pList = NULL;
}

void repeatMaskOutOutput(struct repeatMaskOut *el, FILE *f, char sep, char lastSep) 
/* Print out repeatMaskOut.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
fprintf(f, "%u", el->score);
fputc(sep,f);
fprintf(f, "%f", el->percDiv);
fputc(sep,f);
fprintf(f, "%f", el->percDel);
fputc(sep,f);
fprintf(f, "%f", el->percInc);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->qStart);
fputc(sep,f);
fprintf(f, "%d", el->qEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qLeft);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rFamily);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rStart);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->rEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rLeft);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

