struct Locus
{
private:
	char *nibFileName;
        unsigned int offSet;
	unsigned int startOffset;
	unsigned int endOffset;
        unsigned int locusStart0;
        unsigned int locusStart1;
        unsigned int locusEnd0;
        unsigned int locusEnd1;
	unsigned int size;
	unsigned int nibSize;
	unsigned int tileSize;
	unsigned int tileMask;
	unsigned int tileOverlay;
	std::multimap<std::string, unsigned int> tilePos;
	int constructorError;
	char *dna;
	Locus();		/* no default construct */
	Locus(const Locus &);	/* no copy construct */
	Locus &operator=(const Locus &); /* no assign */
	bool checkNibSig(FILE *f);
	unsigned int getNibSize(FILE *f);
public:
	Locus(const char *a_nibFileName, unsigned int a_startOffset, int unsigned a_endOffset,
	      unsigned int a_tileSize, unsigned int a_tileOverlay,
	      unsigned int a_mumLocusExpand, unsigned int a_locusExpand,
              unsigned int a_nibFileSize);
	Locus(const Locus &locus, unsigned int a_startOffset,
	      unsigned int a_endOffset, unsigned int a_tileSize,
	      unsigned int a_tileOverlay); /* retile a locus subregion */
	~Locus();
	char *get_name() const {return nibFileName;}
	unsigned int get_size() const {return size;}
	unsigned int get_nibSize() const {return nibSize;}
	unsigned int get_startOffset() const {return startOffset;}
	unsigned int get_endOffset() const {return endOffset;}
	unsigned int get_tileSize() const {return tileSize;}
	unsigned int get_tileMask() const {return tileMask;}
	unsigned int get_tileOverlay() const {return tileOverlay;}
	const char *get_dna() const {return dna+offSet;}
	const std::multimap<std::string, unsigned int> &get_tilePos() const {return tilePos;}
	unsigned int get_constructorError() const {return constructorError;}
        void expand_left() {startOffset = locusStart0; offSet = 0;}
        void expand_right() {endOffset = locusEnd0;}
        void set_size() {size = endOffset - startOffset + 1;}
};
