package Clone;

use Exon;
use strict;

sub new {
    my $that = shift;
    my $class = ref($that) || $that;

    if (! @_) {
          my $self = {isVoid => 1};
          bless($self, $class);
          return $self;
    }

    my @line = @_;
     
    my $cloneId      = $line[0];
    my $cloneSeq     = $line[1];
    my $cloneLen     = $line[2];
    my $chromId      = $line[3];
    my $chromStart   = $line[4];
    my $chromEnd     = $line[5];
    my $chromLen     = $line[6];
    my $chromSeq     = $line[7];
    my $strand       = $line[8];
    my $score        = $line[9];
    my $exonsNum     = $line[10];

    my $misoriented = '';
    if (defined($line[11]) && $line[11] == 1) {
	$misoriented = '*';
    }

    my $lch = length($chromSeq); 
    my $lcl = length($cloneSeq);

    if (length($chromSeq) != length($cloneSeq)) {
        print "SpaClone::new -> Mismatch Chr Length : lch-lcl $lch-$lcl\n"; 
        print "cloneId  : $cloneId\n";
        print "CLS : $cloneSeq\n";
        die "CHS : $chromSeq\n"; 
    }

    my @fileInfo = ();
    $fileInfo[0] = $cloneId;
    $fileInfo[1] = $chromId;
    $fileInfo[2] = $strand;
    
    my $self = {
       cloneId     => $cloneId,
       cloneLen    => $cloneLen,
       cloneSeq    => $cloneSeq,
       chromId     => $chromId,
       chromStart  => $chromStart,
       chromEnd    => $chromEnd,
       chromSeq    => $chromSeq,
       chromLen    => $chromLen,
       strand      => $strand,
       score       => $score,
       exonsNum    => $exonsNum,
       misoriented => $misoriented,
       exons       => [],
       isVoid      => 0,
       intronShort => '',
       SEunMapPart => 0,
       SEdist      => [],
       SEdistLen   => 0,
       SENumber    => 0,
       matches     => 0,
       mismatches  => 0,
       deletions   => 0,
       insertions  => 0,
       spliceB     => [],
       delIntrons  => [],
       introns     => [],
       fileInfo	   => \@fileInfo,
       tails       => 0,
       nIns0       => 0,
       nDel0       => 0,
       nInt0	   => 0,
       changeS	   => 0
   };

    bless($self, $class);
    return $self;
}

sub set_stat_info_all {
        my $self = shift;
	my $padding = shift;
	my $nEx = shift;
	my ($exonS, $chStart, $chEnd, $chExonS) = @_;
        my $k;
        my @lineG;
        my ($nSeq, $nCoord, $l, $lt, $nExon);

        $lt = length($exonS);
        $l = ($lt < $padding) ? $lt : $padding;
	
        if ($nEx == 0) {
        	push(@{$self->{fileInfo}[3]}, substr($exonS, -$l));
		push(@{$self->{fileInfo}[5]}, substr($chExonS, -$l));
                push(@{$self->{fileInfo}[4]}, $chEnd);
                #print "$self->{fileInfo}[3][$#{$self->{fileInfo}[3]}] $self->{fileInfo}[4][$#{$self->{fileInfo}[4]]\n";
        }
        elsif ($nEx < $self->{exonsNum}-1) {
               push(@{$self->{fileInfo}[3]}, substr($exonS, 0, $l));
	       push(@{$self->{fileInfo}[5]}, substr($chExonS, 0, $l));
               #print "$self->{fileInfo}[3][$#{$self->{fileInfo}[3]}] ";
               push(@{$self->{fileInfo}[3]}, substr($exonS, -$l));
	       push(@{$self->{fileInfo}[5]}, substr($chExonS, -$l));
               #print "$self->{fileInfo}[3][$#{$self->{fileInfo}[3]] \n";
               push(@{$self->{fileInfo}[4]}, $chStart);
               #print "$self->{fileInfo}[4][$#{self->{fileInfo}[4]}] \n";
               push(@{$self->{fileInfo}[4]}, $chEnd);
               #print "$self->{fileInfo}[4][$#{self->{fileInfo}[4]}]\n";
        }
        else {
                push(@{$self->{fileInfo}[3]}, substr($exonS, 0, $l));
		push(@{$self->{fileInfo}[5]}, substr($chExonS, 0, $l));
                push(@{$self->{fileInfo}[4]}, $chStart);
                #print "$self->{fileInfo}[3][$#{$self->{fileInfo}[3]}] $self->{fileInfo}[4][$#{$self->{fileInfo}[4]}]\n";
        }
}


sub add_exon {
    	my $self = shift;
  	my $number = shift;
	
	if ($number == 0) {
        	if (($self->{misoriented} eq '*') && ($self->{strand} eq '-') && ($_[5] == $self->{chromStart})) {
                	$self->{changeS} = 1;
                	$self->{strand} = '+';
                	$_[8] = $self->{strand};
        	}
        	elsif (($self->{misoriented} eq '*') && ($self->{strand} eq '+') && ($_[6] == $self->{chromEnd})) {
                	$self->{changeS} = 1;
                	$self->{strand} = '-';
                	$_[8] = $self->{strand};
        	}
   	}
   	else {
        	if ($self->{changeS}) {
                	$_[8] = $self->{strand};
        	}
   	}
 
    	$self->{exons}[$number] = Exon->new(@_);
}


sub set_stat_info {
	my $self = shift;
	my $padding = shift;

	if ($self->{exonsNum} < 2) {
		return;
	}

	$self->{fileInfo}[0] = $self->{cloneId};
        $self->{fileInfo}[1] = $self->{chromId};
        $self->{fileInfo}[2] = $self->{strand};
        my ($exonS, $chStart, $chEnd, $chExonS);
                                                                                                                                     
        for (my $i = 0; $i < $self->{exonsNum}; $i++) {
                $exonS = $self->{exons}[$i]->{exonSeq};
                $chStart = $self->{exons}[$i]->{chromStart};
                $chEnd = $self->{exons}[$i]->{chromEnd};
                $chExonS = $self->{exons}[$i]->{chromSeq};
                set_stat_info_all($self, $padding, $i, $exonS, $chStart, $chEnd, $chExonS);
        }
}
	
		    
    
sub set_splicing_boundary {
    my $self = shift;
                                                                                                                                                             
    if (length($self->{cloneSeq}) != length($self->{chromSeq})) {
        print "$self->{cloneSeq}\n\n";
        print "$self->{chromSeq}\n";
        die "Spa -> set_plicing_boundary : They are expected to have the same length\n";
    }
                                                                                                                                                             
    my $k = 0;
    my $L = 0;
    my $splice;
    my $number = 0;
    my ($i, $j);

    for ($i = 0; $i < $self->{exonsNum}-1; $i++) {
         $splice = substr($self->{chromSeq}, $L+length($self->{exons}[$i]->{exonSeq}), 2);
         if (substr($self->{exons}[$i]->{exonSeq}, -1) eq "-") {
             #print "first : $self->{exons}[$i]->{exonSeq}\n";
             $self->{delIntrons}[$k] = 1;
         }
         else {
             $self->{delIntrons}[$k] = 0;
         }
         $k++;
         $splice .= substr($self->{chromSeq}, $L+length($self->{exons}[$i]->{exonSeq})+7, 2);
         if (substr($self->{exons}[$i+1]->{exonSeq}, 0, 1) eq "-") {
             #print "second : $self->{exons}[$i+1]->{exonSeq}\n";
             $self->{delIntrons}[$k] = 1;
         }
         else {
             $self->{delIntrons}[$k] = 0;
         }
         $k++;
         #print "$splice\n";
         $self->{spliceB}[$number] = $splice;
         $number++;
         $L += length($self->{exons}[$i]->{exonSeq})+9;
    }
    my $tmp = $#{$self->{delIntrons}};
    #print "$tmp\n"; 
    for ($i = 0; $i < $#{$self->{delIntrons}}; $i = $i + 2) {
         if (($self->{delIntrons}[$i] == 1) && ($self->{delIntrons}[$i+1] == 1)) {
              $j = int($i/2);
              #print "$i $j \n";
              #print "$self->{exons}[$j]->{distDelLen}\n";
              #print "$self->{exons}[$j+1]->{distDelLen}\n";
              $self->{exons}[$j]->{distDel}[$self->{exons}[$j]->{distDelLen}-1] += $self->{exons}[$j+1]->{distDel}[0];
              $self->{exons}[$j+1]->{distDelLen}--;
              shift(@{$self->{exons}[$j+1]->{distDel}});
         }
         elsif ($self->{delIntrons}[$i+1] == 1) {
              $j = int($i/2);
              #print "$i $j \n";
              #print "$self->{exons}[$j+1]->{distDelLen}\n";
              $self->{exons}[$j]->{distDel}[$self->{exons}[$j]->{distDelLen}] = $self->{exons}[$j+1]->{distDel}[0];
              $self->{exons}[$j]->{distDelLen}++;
              $self->{exons}[$j+1]->{distDelLen}--;
              shift(@{$self->{exons}[$j+1]->{distDel}});
         }
   }
}


sub set_introns {
    my $self = shift;
    my $i;                                                                                                                                                         
    if ($self->{strand} eq "+") {
       	for ($i = 0; $i < $self->{exonsNum}-1; $i++) {
       		$self->{introns}[$i] = $self->{exons}[$i+1]->{chromStart}-$self->{exons}[$i]->{chromEnd}-1;
       	}
    }
    else {
       	for ($i = 0; $i < $self->{exonsNum}-1; $i++) {
       		$self->{introns}[$i] = $self->{exons}[$i]->{chromEnd}-$self->{exons}[$i+1]->{chromStart}-1;
       	}
    }
}


sub set_data {
    my $self = shift;
    my $j;
    my $t;
    my $c;
    my $e;
    for (my $i = 0; $i < $self->{exonsNum}; $i++) {
         $self->{exons}[$i]->set_data();
         if ($i == 0) {
             $c = $self->{exons}[$i]->{chromSeq};
             for ($j = 0; $j < length($self->{exons}[$i]->{chromSeq}); $j++) {
		  $e = substr($c, $j, 1);
                  if ($e eq '-') {
                      $self->{SEunMapPart}++;
                  }
                  else {
                      last;
                  }
             }
             if ($self->{SEunMapPart} > 0) {
                 $self->{SEdist}[$self->{SENumber}] = $self->{SEunMapPart};
                 $self->{SENumber}++;
             }
             if ($self->{exonsNum} == 1) {
                 $t = 0;
                 for ($j = length($self->{exons}[$i]->{chromSeq})-1; $j > -1; $j--) {
		      $e = substr($c, $j, 1);
                      if (($e eq '-') || ($e eq '*')) {
                          $t++;
                      } 
                      else {
                          last;
                      }
                 }
                 if (($t > 0) && ($t < $self->{cloneLen})) {
                     $self->{SEunMapPart} += $t;
                     $self->{SEdist}[$self->{SENumber}] = $t;
                     $self->{SENumber}++;
                     $t = 0;
                 }
             }
         }
         elsif ($i == $self->{exonsNum}-1) {
                $t = 0;
                $c = $self->{exons}[$i]->{chromSeq};
                for ($j = length($self->{exons}[$i]->{chromSeq})-1; $j > -1; $j--) { 
		     $e = substr($c, $j, 1);
                     if (($e eq '-') && ($e eq '*')) {
                         $t++;
                     }
                     else {
                         $self->{SEunMapPart} += $t;
                         last;
                     }
                } 
                if ($t > 0) {
                    $self->{SEdist}[$self->{SENumber}] = $t;
                    $self->{SENumber}++;
                }
         }
         $self->{matches}     += $self->{exons}[$i]->{m};
         $self->{mismatches}  += $self->{exons}[$i]->{mm};
         $self->{deletions}   += $self->{exons}[$i]->{del};
         $self->{insertions}  += $self->{exons}[$i]->{ins};
    } 
    set_splicing_boundary($self);
    set_introns($self);
    set_zero_insertion($self);
    set_zero_deletion($self);
    set_zero_intron($self);
}

sub check_data {
    my $self = shift;
    my ($i, $j);
    
    #my $t = $self->{cloneLen}-$self->{exons}[$self->{exonsNum}-1]->{exonEnd};
    my $m = $self->{matches} + $self->{mismatches} + $self->{insertions};
    if ($m != $self->{cloneLen}) {
        print "Message from Spa : $self->{cloneId}\n"; 
        print "$self->{matches} $self->{mismatches} $self->{insertions} $m $self->{cloneLen}\n";
        printf "%5d %5d %5d %5d %5d %5d\n",
                  $self->{matches}, $self->{mismatches}, $self->{deletions},
                  $self->{insertions}, $self->{SEunMapPart}, $self->{cloneLen}; 
       die "Check failed\n";
    }

    my $S = 0;
    for ($i = 0; $i < $self->{exonsNum}; $i++) {
         for ($j = 0; $j < $self->{exons}[$i]->{distInsLen}; $j++) {
              $S += $self->{exons}[$i]->{distIns}[$j];
         }
   }
   if ($S != $self->{insertions}) {
       print "Mismatch insertion numbers : $S $self->{insertions}\n";
       die "Spa -> check_data failed\n";
   }

   $S = 0;
   for ($i = 0; $i < $self->{exonsNum}; $i++) {
         for ($j = 0; $j < $self->{exons}[$i]->{distDelLen}; $j++) {
              $S += $self->{exons}[$i]->{distDel}[$j];
         }
   }
   if ($S != $self->{deletions}) {
       print "Mismatch deletion numbers : $S $self->{deletions}\n";
       die "Spa -> check_data failed\n";
   }    
}

sub print_data {
    my $self = shift;
    my $file = shift;
    my $number = shift;
    my $intronsNum = $self->{exonsNum}-1;

    #printf $file "%5d %8d %8d %8d %8d %5d %5d %5d %5d %5d %5d %7.2f %5d\n", $number,
    printf $file "%-30s %8d %8d %8d %8d %5d %5d %5d %5d %s %s\n", $self->{cloneId},
                  $self->{matches}, $self->{mismatches}, $self->{deletions},
                  $self->{insertions}, $self->{SEunMapPart}, $intronsNum, 
                  $self->{cloneLen}, $self->{tails}, $self->{misoriented},
                  $self->{intronShort};  
}

sub print {
    my $self = shift;

    for (my $i = 0; $i < $self->{exonsNum}; $i++) {
         $self->{exons}[$i]->print();
    }
}

sub set_zero_insertion {
    my $self = shift;
    
    my $n_ins0 = 0;
    for (my $i = 0; $i < $self->{exonsNum}; $i++) {
         for (my $j = 0; $j < $self->{exons}[$i]->{distInsLen}; $j++) {
              $n_ins0++;
         } 
    }
    $n_ins0 = $self->{matches} + $self->{mismatches} - 1 - $n_ins0 + $self->{SENumber};
    if ($n_ins0 < 0) {
        die "insertions number : $n_ins0\n";
    }
    $self->{nIns0} = $n_ins0; 
}

sub set_zero_deletion {
    my $self = shift;

    my $score = 0;
    my $n_del0 = 0;
    for (my $i = 0; $i < $self->{exonsNum}; $i++) {
         for (my $j = 0; $j < $self->{exons}[$i]->{distDelLen}; $j++) {
              $n_del0++;
         }          
    }
    $n_del0 = $self->{matches} + $self->{mismatches} - 1 - $n_del0;
    if ($n_del0 < 0) {
        die "Dletion number: $n_del0\n";
    }
    $self->{nDel0} = $n_del0;
}

sub set_zero_intron {
    my $self = shift;
    my $n_int0 = $self->{matches} + $self->{mismatches} - $self->{exonsNum};
    $self->{nInt0} = $n_int0;
}

sub get_tails {
    my $self = shift;
    
    return $self->{cloneLen}-$self->{exons}[$self->{exonsNum}-1]->{exonEnd};
}            

sub add_supplement_info {
	my $self = shift;
	my $info = shift;

	$self->{fileInfo}[$#{$self->{fileInfo}}+1] = $info;
	#print "$#{$self->{fileInfo}}-$self->{fileInfo}[$#{$self->{fileInfo}}]\n";
}	

1;       
