#ifndef EXON_H
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* struct Exon */
typedef struct _exonElem {
  unsigned int clone_beg;
  unsigned int clone_end;
  unsigned int genome_beg;
  unsigned int genome_end;
  char *clone_seq;
  char *genome_seq;
  int score;
  struct _exonElem *next;
} exonElem;

typedef struct _exonList {
  exonElem *head;
  exonElem *tail;
  /*
    int      (*match)(const void *key1, const void *key2);
    void     (*destroy)(void *data);
  */
  int      size;
} exonList;

void exonInit ( exonList *exon );

int exonAdd           ( exonList *exon, exonElem *elem,
			unsigned int clone_beg, unsigned int clone_end, 
			unsigned int genome_beg, unsigned int genome_end, 
			char *clone_seq, char *genome_seq, int score );
int exonAddMalloc     ( exonList *exon, exonElem *elem,
			unsigned int clone_beg, unsigned int clone_end, 
			unsigned int genome_beg, unsigned int genome_end, 
			char *clone_seq, char *genome_seq, int score );
int exonAddBeg        ( exonList *exon,
			unsigned int clone_beg, unsigned int clone_end, 
			unsigned int genome_beg, unsigned int genome_end, 
			char *clone_seq, char *genome_seq, int score );
int exonAddBegMalloc  ( exonList *exon,
			unsigned int clone_beg, unsigned int clone_end, 
			unsigned int genome_beg, unsigned int genome_end, 
			char *clone_seq, char *genome_seq, int score );


int exonFree      ( exonList *exon );
int exonRemNext   ( exonList *exon, exonElem *elem );

#endif /* EXON_H */
