#####################################################################
# This class contains information about splice junction             
#                                                                   
# Usage : $boundary = Boundary->new($p, $cll, $clr, $chl, $chr, $mis)     
#         $p 	: is the length of the clone sequence upstream the     
#              	  the splice junction in the mapping.                                 
#         $cll	: clone sequence upstream
#	  $clr	: clone sequence downstream
#	  $chr  : chromosome sequence that maps $cll
# 	  $chr  : chromosome sequence that maps $clr
#	  $mis	: misoriented information
# 
#         string $boundary->get_tetramers()
#######################################################################

package Boundary;

sub new {
	my $that = shift;
    	my $class = ref($that) || $that;

	my $self = {
		padding		=>	$_[0],
		clBoundarySeqL	=>	lc($_[1]),
		clBoundarySeqR	=>	lc($_[2]),
		chBoundarySeqL	=>	lc($_[3]),
		chBoundarySeqR	=>	lc($_[4]),
		tetraNumber	=>	1,
		tetramers	=> 	''
	};

	bless($self, $class);
    	return $self;
}

sub check {
	my $self = shift;
	my $log = shift;
	my $b;

	if ($self->{padding} < 1) {
		print $log "Bad padding : $self->{padding} \n";
		print "$self->{clBoundarySeqL}-$self->{clBoundarySeqR}\n";
		print "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n";
		return 0;
	}
	if (length($self->{clBoundarySeqL}) != length($self->{clBoundarySeqR})) {
		print $log "Mismatch between clBoundarySeqL and clBoundarySeqR\n";
		print $log "$self->{clBoundarySeqL}-$self->{clBoundarySeqR}\n";
		print $log "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n";
		return 0;
	}
	if (length($self->{chBoundarySeqL}) != length($self->{chBoundarySeqR})) {
     		print $log "Mismatch between chBoundarySeqL and chBoundarySeqR\n";
                print $log "$self->{clBoundarySeqL}-$self->{clBoundarySeqR}\n";
                print $log "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n"; 
                return 0;
        }
	if (length($self->{clBoundarySeqL}) != $self->{padding}) {
		print $log "Bad clBoundarySeqL length\n";
		print $log "$self->{clBoundarySeqL}-$self->{clBoundarySeqR}\n";
                print $log "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n";
		return 0;
	}
	if (length($self->{chBoundarySeqL}) != 2*$self->{padding}+1) {
		print $log "Bad chBoundarySeqL length\n";
                print $log "$self->{clBoundarySeqL}-$self->{clBoundarySeqR}\n";
                print $log "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n";
                return 0;
        }
	if (($b = index($self->{chBoundarySeqL},$self->{clBoundarySeqL})) != 0) {
		print $log "clBoundarySeqL not substring of chBoundarySeqL : $b\n";
	 	print $log "$self->{clBoundarySeqL}-$self->{clBoundarySeqR}\n";
                print $log "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n";
		return 0;
	}
	if (index($self->{chBoundarySeqR},$self->{clBoundarySeqR}, $self->{padding}+1) == -1 ) {
                print $log "clBoundarySeqR not substring of chBoundarySeqR : -1\n";
                print $log "$self->{clBoundarySeqL}-$self->{clBoundarySeqR}\n";
                print $log "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n"; 
                return 0;
        }
	if (($self->{chBoundarySeqL} =~ /[^atgc]/) || ($self->{clBoundarySeqR} =~ /[^atgc]/) || 
	    ($self->{chBoundarySeqR} =~ /[^atgc]/) || ($self->{clBoundarySeqL} =~ /[^atgc]/)) {
		return 0;
	}
	return 1;
}

sub get_spliceB {
	my $self = shift;

	#print "$self->{chBoundarySeqL}-$self->{chBoundarySeqR}\n";
	my $a = substr($self->{chBoundarySeqL}, $self->{padding}, 2);
	my $b = substr($self->{chBoundarySeqR}, $self->{padding}-1, 2);
	return uc($a.$b);
}

sub get_tetramers_L {
	my $self = shift;
	my ($a, $b, $c, $d);

	my $cloneL = $self->{clBoundarySeqL};
	my $chromR = $self->{chBoundarySeqR};
	my $chromL = $self->{chBoundarySeqL};
	my $s = '';	

	for (my $i = $self->{padding}-1; $i > 0; $i--) {
		$a = substr($cloneL, $i, 1);
		$b = substr($chromR, $i+1, 1);
		if ($a eq $b) {
			$c = substr($chromL, $i, 2);
			$d = substr($chromR, $i-1, 2);
			if ($s eq '') {
                                $s = uc($c.$d);
                        }
                        else {
                                $s .= "\t" . uc($c.$d);
                        }	
			$self->{tetraNumber}++;
		}
		else {
			last;
		}
	}
	return $s;
}

sub get_tetramers_R {
	my $self = shift;

	my ($a, $b, $c, $d);
	
	my $cloneR = $self->{clBoundarySeqR};
        my $chromL = $self->{chBoundarySeqL};
	my $chromR = $self->{chBoundarySeqR};
	my $s = '';

	for (my $i = 0; $i < $self->{padding}-1; $i++) {
		$a = substr($cloneR, $i, 1);
		$b = substr($chromL, $self->{padding}+$i, 1);
		if ($a eq $b) {
			$c = substr($chromL, $self->{padding}+$i+1, 2);
			$d = substr($chromR, $self->{padding}+$i, 2);
			if ($s eq '') {
				$s = uc($c.$d);
			}
			else {
				$s .= "\t" . uc($c.$d);
			}
                        $self->{tetraNumber}++;
                }
                else {
                        last;
                }
        }
        return $s;
}


sub set_tetramers {
	my $self = shift;
	my $res;

	my $tetra = $self->get_spliceB();
	if (($res = $self->get_tetramers_L()) ne '') {
		$tetra .= "\t" . $res;
	}
	if (($res = $self->get_tetramers_R()) ne '') {
	     $tetra .= "\t" . $res;
	}
	$self->{tetramers} = $self->{tetraNumber}."\t".$tetra;
	#if ($self->{misoriented} eq '*') {
	#	print "$self->{tetramers}\n";
	#	printf "%21s\t%21s\n", $self->{chBoundarySeqL}, $self->{chBoundarySeqR};
	#	printf "%-21s\t%21s\n\n\n", $self->{clBoundarySeqL}, $self->{clBoundarySeqR};
	#}
}

sub print {
	my $self = shift;
	my $out = shift;

	print $out "$self->{tetramers}\n";
}

sub print_info {
	my $self = shift;
	my $log  = shift;

	print $log "$self->{tetramers}\n";
	printf $log "%21s\t%21s\n", $self->{chBoundarySeqL}, $self->{chBoundarySeqR};
	printf $log "%-21s\t%21s\n\n\n", $self->{clBoundarySeqL}, $self->{clBoundarySeqR}; 
}	

1;		     
