package Match;

use strict;
use warnings;
                                                                                                                                                               
sub new {
    	my $that = shift;
    	my $class = ref($that) || $that;
                                                                                                                                                               
	my $pmm = shift;
                                                                                                                                                               
	unless (defined($pmm) && $pmm > 0) {
                die "Mismatch Input undefined\n";
        }

	my $pm = 1.0 - $pmm;

	my $self = {
		score_match	=> $pm,
		score_mismatch	=> $pmm
	};

    	bless($self, $class);
    	return $self;
}

sub new_unbiased {
	my $that = shift;
	my $class = ref($that) || $that;

	my $pmm = shift;
        my $pm = 1.0 - $pmm;
                                                                                                                                                         
                                                                                                                                                         
        unless (defined($pmm) && $pmm > 0) {
                die "Mismatch Input undefined\n";
        }
                                                                                                                                                         
        my $self = {
                score_match     => $pm,
                score_mismatch  => $pmm
        };
                                                                                                                                                         
        bless($self, $class);
        return $self;
}


sub print {
	my $self = shift;

	print "score_match $self->{score_match}\n";
    	print "score_mismatch $self->{score_mismatch}\n\n\n";
}

sub print_data {
	my $self = shift;
	my $out = shift;

	print $out "score_match $self->{score_match}\n";
	print $out "score_mismatch $self->{score_mismatch}\n\n\n";
}

1;
