#include "exon.h"

/************************************************************************/
/* exon_init                                                            */
/************************************************************************/
void exonInit ( exonList *exon ) {
  exon->size = 0;
  exon->head = NULL;
  exon->tail = NULL;
  return;
}
/************************************************************************/
/* end exon_init                                                        */
/************************************************************************/

/************************************************************************/
/* exonAdd                                                              */
/************************************************************************/
int exonAdd ( exonList *exon, exonElem *elem,
	      unsigned int clone_beg, unsigned int clone_end, 
	      unsigned int genome_beg, unsigned int genome_end, 
	      char *clone_seq, char *genome_seq, int score ) {

  exonElem *new_exon;

  if ( (new_exon = (exonElem *)malloc(sizeof(exonElem))) == NULL ) {
    printf ("ERROR\n");
    return -1;
  }

  new_exon->clone_beg = clone_beg;
  new_exon->clone_end = clone_end;
  new_exon->genome_beg = genome_beg;
  new_exon->genome_end = genome_end;
  new_exon->score = score;

  new_exon->clone_seq = clone_seq;
  new_exon->genome_seq = genome_seq;

  //  printf ( "len %i str %s str %s\n", strlen(new_exon->clone_seq), clone_seq, new_exon->clone_seq );
  //  printf ( "len %i str %s str %s\n", strlen(new_exon->genome_seq), genome_seq, new_exon->genome_seq );
  
  if ( elem == NULL ) {
    if ( exon->size == 0 ) 
      exon->tail = new_exon;

    new_exon->next = exon->head;
    exon->head = new_exon;
  }
  else {
    if ( elem->next == NULL )
      exon->tail = new_exon;
    
    new_exon->next = elem->next;
    elem->next = new_exon;
  }
  exon->size++;
  return 0;

}
/************************************************************************/
/* end exonAdd                                                          */
/************************************************************************/

/************************************************************************/
/* exonAddMalloc                                                        */
/************************************************************************/
int exonAddMalloc ( exonList *exon, exonElem *elem,
		    unsigned int clone_beg, unsigned int clone_end, 
		    unsigned int genome_beg, unsigned int genome_end, 
		    char *clone_seq, char *genome_seq, int score ) {

  exonElem *new_exon;
  int seq_len = 0;

  if ( (new_exon = (exonElem *)malloc(sizeof(exonElem))) == NULL ) {
    printf ("ERROR\n");
    return -1;
  }

  new_exon->clone_beg = clone_beg;
  new_exon->clone_end = clone_end;
  new_exon->genome_beg = genome_beg;
  new_exon->genome_end = genome_end;
  new_exon->score = score;

  seq_len = strlen(clone_seq) + 1;

  if ( ( new_exon->clone_seq = (char *)malloc( seq_len ) ) == NULL ) {
    printf ("ERROR in malloc!\n");
  }
  strncpy ( new_exon->clone_seq, clone_seq, seq_len );
  
  //  printf ("len %i str %s str %s\n", seq_len, clone_seq, new_exon->clone_seq );
  
  seq_len = strlen(genome_seq) + 1;
  if ( ( new_exon->genome_seq = (char *)malloc( seq_len ) ) == NULL ) {
    printf ("ERROR in malloc!\n");
  }
  strncpy ( new_exon->genome_seq, genome_seq, seq_len );
  
  if ( elem == NULL ) {
    if ( exon->size == 0 ) 
      exon->tail = new_exon;
    new_exon->next = exon->head;
    exon->head = new_exon;
  }
  else {
    if ( elem->next == NULL )
      exon->tail = new_exon;
    
    new_exon->next = elem->next;
    elem->next = new_exon;
  }
  exon->size++;
  return 0;

}
/************************************************************************/
/* end exonAddMalloc                                                    */
/************************************************************************/

/************************************************************************/
/* exonAddBeg                                                          */
/************************************************************************/
int exonAddBeg ( exonList *exon,
		  unsigned int clone_beg, unsigned int clone_end, 
		  unsigned int genome_beg, unsigned int genome_end, 
		  char *clone_seq, char *genome_seq, int score ) {

  exonElem *new_exon;

  if ( (new_exon = (exonElem *)malloc(sizeof(exonElem))) == NULL ) {
    printf ("ERROR\n");
    return -1;
  }

  new_exon->clone_beg = clone_beg;
  new_exon->clone_end = clone_end;
  new_exon->genome_beg = genome_beg;
  new_exon->genome_end = genome_end;
  new_exon->score = score;

  new_exon->clone_seq = clone_seq;
  new_exon->genome_seq = genome_seq;

  //  printf ( "len %i str %s str %s\n", strlen(new_exon->clone_seq), clone_seq, new_exon->clone_seq );
  //  printf ( "len %i str %s str %s\n", strlen(new_exon->genome_seq), genome_seq, new_exon->genome_seq );

  new_exon->next = exon->head;
  exon->head = new_exon;
  exon->size++;
  return 0;

}
/************************************************************************/
/* end exonAddBeg                                                       */
/************************************************************************/

/************************************************************************/
/* exonAddBegMalloc                                                    */
/************************************************************************/
int exonAddBegMalloc ( exonList *exon,
			unsigned int clone_beg, unsigned int clone_end, 
			unsigned int genome_beg, unsigned int genome_end, 
			char *clone_seq, char *genome_seq, int score ) {

  exonElem *new_exon;
  int seq_len = 0;

  if ( (new_exon = (exonElem *)malloc(sizeof(exonElem))) == NULL ) {
    printf ("ERROR\n");
    return -1;
  }

  new_exon->clone_beg = clone_beg;
  new_exon->clone_end = clone_end;
  new_exon->genome_beg = genome_beg;
  new_exon->genome_end = genome_end;
  new_exon->score = score;

  seq_len = strlen(clone_seq) + 1;

  if ( ( new_exon->clone_seq = (char *)malloc( seq_len ) ) == NULL ) {
    printf ("ERROR in malloc!\n");
  }
  strncpy ( new_exon->clone_seq, clone_seq, seq_len );
  
  //  printf ("len %i str %s str %s\n", seq_len, clone_seq, new_exon->clone_seq );
  
  seq_len = strlen(genome_seq) + 1;
  if ( ( new_exon->genome_seq = (char *)malloc( seq_len ) ) == NULL ) {
    printf ("ERROR in malloc!\n");
  }
  strncpy ( new_exon->genome_seq, genome_seq, seq_len );

  new_exon->next = exon->head;
  exon->head = new_exon;
  exon->size++;
  return 0;

}
/************************************************************************/
/* end exonAddBegMalloc                                                */
/************************************************************************/

/************************************************************************/
/* exonFree                                                             */
/************************************************************************/
int exonFree ( exonList *exon ) {
  while ( exon->size > 0 ) {
    exonRemNext( exon,  NULL );
  }
  return 0;
}
/************************************************************************/
/* end exonFree                                                         */
/************************************************************************/

/************************************************************************/
/* exonRemNext                                                          */
/************************************************************************/
int exonRemNext ( exonList *exon, exonElem *elem ) {
  exonElem *old_elem;
  if ( exon->size == 0 )
    return -1;

  if ( elem == NULL ) {
    old_elem = exon->head;
    exon->head = exon->head->next;
    if ( exon->size == 1 ) 
      exon->tail = NULL;
  }
  else {
    if ( elem->next == NULL )
      return -1;

    old_elem = elem->next;
    elem->next = elem->next->next;

    if ( elem->next == NULL )
      exon->tail = elem;
  }
  free(old_elem->clone_seq);
  free(old_elem->genome_seq);
  free(old_elem);
  exon->size--;
  return 0;
}
/************************************************************************/
/* end exonRemNext                                                      */
/************************************************************************/
