#include <stdio.h>
#include <math.h>
#include <float.h>
#include <limits.h>
#define __THROW_BAD_ALLOC
//#define SHOW_INTRON_SEARCH
/* __THROW_BAD_ALLOC is needed for some stl implementations (g++) */
/* otherwise, cerr, operator <<, and endl are referenced in <map> */
#include <map>
#include <set>
#include <list>
#include "spa.h"
#include "dnaSeq.h"
#include "locus.h"


using namespace std;

static Cell no_child = {0}; /* placeholder address for cell without child */

/* NT2VAL lookup table of character code to base value:
	t/T = 0, c/C = 1, a/A = 2, g/G = 3, <unknown(N)> = 4
*/
static const unsigned int NT2VAL[128] = {
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,2,4,1,4,4,4,3,4,4,4,4,4,4,4,4,4,4,4,4,0,4,4,4,4,4,4,4,4,4,4,4,
	4,2,4,1,4,4,4,3,4,4,4,4,4,4,4,4,4,4,4,4,0,4,4,4,4,4,4,4,4,4,4,4};

/* NT2CVAL complement of NT2VAL character lookup:
	t/T = 2, c/C = 3, a/A = 0, g/G = 1, <unknown(N)> = 4
*/
static const unsigned int NT2CVAL[128] = {
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,0,4,3,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,2,4,4,4,4,4,4,4,4,4,4,4,
	4,0,4,3,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,2,4,4,4,4,4,4,4,4,4,4,4};

/*******************************************************************************
Parameter Default Values
*******************************************************************************/

static const unsigned int DEFAULT_STEP_TILESIZE = 4;
static const unsigned int DEFAULT_MAX_TILESIZE = 12;
static const unsigned int MINIMUM_RETILE_TILESIZE = 4;
static const double DEFAULT_SCORE_MATCH = log(0.95);
static const double DEFAULT_SCORE_MISMATCH = log(0.05);
static const double DEFAULT_SCORE_SPLICE[625] = {
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0001526757),log(0.0000440520),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000440520),log(0.0000168960),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000440520),log(0.0000168960),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000168960),log(0.0000101070),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0001051263),log(0.0000078440),log(0.0000078440),log(0.0000321646),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000321646),log(0.0000078440),log(0.0000078440),log(0.0000139242),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000321646),log(0.0000078440),log(0.0000078440),log(0.0000139242),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000139242),log(0.0000078440),log(0.0000078440),log(0.0000093641),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000957458),log(0.0010570852),log(0.0000078440),log(0.0000078440),log(0.0002921298),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000298195),log(0.0002701543),log(0.0000078440),log(0.0000078440),log(0.0000789155),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0001112722),log(0.0001423248),log(0.0000078440),log(0.0000673213),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000337011),log(0.0000414642),log(0.0000078440),log(0.0000227133),
	log(0.0000078440),log(0.0000078440),log(0.0001526757),log(0.0000078440),log(0.0000440520),
	log(0.0000078440),log(0.0000078440),log(0.0001850223),log(0.0000078440),log(0.0000521386),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0001035090),log(0.0000317603),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000883465),log(0.0000317603),log(0.0000339487),
	log(0.0000078440),log(0.0000078440),log(0.0000440520),log(0.0000078440),log(0.0000168960),
	log(0.0000078440),log(0.0000078440),log(0.0000521386),log(0.0000078440),log(0.0000189177),
	log(0.0000298195),log(0.0002960114),log(0.0000414642),log(0.0000317603),log(0.0000997638),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000133379),log(0.0000798859),log(0.0000363747),log(0.0000138231),log(0.0000358554),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0001604389),log(0.0000459928),
	log(0.0000078440),log(0.0000078440),log(0.0003454611),log(0.0000078440),log(0.0000922483),
	log(0.0000078440),log(0.0000078440),log(0.0001397371),log(0.9839858711),log(0.2460353241),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0002186626),log(0.0000605487),
	log(0.0000078440),log(0.0000078440),log(0.0001252216),log(0.2460932042),log(0.0615585285),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0047730566),log(0.0011991472),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0011991472),log(0.0003056698),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0001099783),log(0.0000333776),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000333776),log(0.0000142274),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0057848566),log(0.0000078440),log(0.0014520972),
	log(0.0001099783),log(0.0000078440),log(0.0000078440),log(0.0003182901),log(0.0001109891),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000970397),log(0.0000301430),
	log(0.0000333776),log(0.0000078440),log(0.0014520972),log(0.0001077545),log(0.0004002683),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000459928),log(0.0000173812),
	log(0.0000078440),log(0.0000078440),log(0.0015365014),log(0.0000078440),log(0.0003900084),
	log(0.0000333776),log(0.0000078440),log(0.0000408173),log(0.2472967990),log(0.0618447095),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000828476),log(0.0000265949),
	log(0.0000142274),log(0.0000078440),log(0.0003982517),log(0.0618583709),log(0.0155696735),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000459928),log(0.0000173812),
	log(0.0000078440),log(0.0000078440),log(0.0000922483),log(0.0000078440),log(0.0000289451),
	log(0.0000298195),log(0.0002701543),log(0.0000408173),log(0.2460023508),log(0.0615857855),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000605487),log(0.0000210202),
	log(0.0000133379),log(0.0000734216),log(0.0000371884),log(0.0615291841),log(0.0154132830),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000321646),log(0.0000078440),log(0.0000078440),log(0.0000139242),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0011991472),log(0.0003056698),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000139242),log(0.0000078440),log(0.0003056698),log(0.0000838205),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000337011),log(0.0000414642),log(0.0000333776),log(0.0000290967),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000078440),
	log(0.0000078440),log(0.0000143083),log(0.0000162491),log(0.0000142274),log(0.0000131572),
	log(0.0000078440),log(0.0000078440),log(0.0000440520),log(0.0000078440),log(0.0000168960),
	log(0.0000078440),log(0.0000078440),log(0.0014963917),log(0.0000078440),log(0.0003799810),
	log(0.0000333776),log(0.0000078440),log(0.0000078440),log(0.0001455797),log(0.0000486613),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000301430),log(0.0000134188),
	log(0.0000142274),log(0.0000078440),log(0.0003890329),log(0.0000478527),log(0.0001147393),
	log(0.0000078440),log(0.0000078440),log(0.0000168960),log(0.0000173812),log(0.0000124913),
	log(0.0000078440),log(0.0000139242),log(0.0004010820),log(0.0000078440),log(0.0001076736),
	log(0.0000197213),log(0.0000798859),log(0.0000244924),log(0.0618451138),log(0.0154923033),
	log(0.0000078440),log(0.0000078440),log(0.0000078440),log(0.0000265949),log(0.0000125318),
	log(0.0000108133),log(0.0000273745),log(0.0001125786),log(0.0154742335),log(0.0039062500)};
static const double DEFAULT_MAX_SPLICE_SCORE = DEFAULT_SCORE_SPLICE[
		NT2VAL[(int)'g']*125+NT2VAL[(int)'t']*25+NT2VAL[(int)'a']*5+NT2VAL[(int)'g']];


static const unsigned int DEFAULT_SHORTEST_INTRON_LENGTH_IN_TABLE = 30;
static const unsigned int DEFAULT_MINIMUM_INTRON_LENGTH_POSSIBLE = 30;
static const unsigned int DEFAULT_LONGEST_INTRON_LENGTH_IN_TABLE = 195028;
static const unsigned int SCORE_INTRON_LENGTH_TABLE_SIZE = 100;

static double intron_bin_log_step = 0.0;

static unsigned int shortest_intron_length_in_table	= DEFAULT_SHORTEST_INTRON_LENGTH_IN_TABLE;
static unsigned int minimum_intron_length_possible	= DEFAULT_MINIMUM_INTRON_LENGTH_POSSIBLE;
static unsigned int longest_intron_length_in_table 	= DEFAULT_LONGEST_INTRON_LENGTH_IN_TABLE;

static double score_intron_length_table[SCORE_INTRON_LENGTH_TABLE_SIZE] = {
	-15.6520084224948,-16.0574735308243,-15.8343299792521,-16.0574735308215,
	-16.1220120516799,-15.8504593614533,-16.7018305477217,-16.1628340462408,
	-15.2465433146176,-13.492524173234,-12.3050325950993,-11.5077405516034,
	-11.4061953457637,-11.7234561152142,-11.9534537029558,-12.2744209065703,
	-12.4386020735305,-12.5274432771943,-12.6815939570226,-12.737847802733,
	-12.8243250465485,-12.839774869004,-12.864725558416,-12.9127826040204,
	-13.0704749371162,-13.0886629147143,-13.1159628113136,-13.2247674146561,
	-13.2484474122577,-13.2798423957608,-13.3640027793624,-13.3006331654301,
	-13.4077589066109,-13.4470361584669,-13.4703362582647,-13.5547186380879,
	-13.5580246954131,-13.6089345250849,-13.7014707780056,-13.7602599815087,
	-13.8731523582014,-13.8527769385257,-13.9497655508719,-14.0638027302653,
	-14.0665191247752,-14.1976605982283,-14.2520975114819,-14.3513815328708,
	-14.5223515122438,-14.5972480164538,-14.7330064373637,-14.8913973165661,
	-14.9926972392819,-15.1495510484987,-15.3114368862196,-15.5574936823138,
	-15.6373707693627,-15.8854945984823,-16.0580342259721,-16.2852574615465,
	-16.3476650146804,-16.6229252802648,-16.7545717239205,-16.7821829640985,
	-17.0044894190516,-17.173509460493,-17.431464482409,-17.5177315531956,
	-17.7111727715351,-17.9155740697258,-18.096716891731,-18.2537175955354,
	-18.4757625095064,-18.4941382066976,-18.7689119888444,-18.7153339878989,
	-19.0187420720102,-19.1564887219132,-19.4405082732011,-19.5884711414724,
	-19.7502895187572,-19.7874396345709,-20.1145959294525,-20.559985704828,
	-20.2625715166995,-20.4895424932719,-20.7820298607307,-20.9982414450152,
	-21.2048466948083,-21.2572824718301,-21.4812695407804,-21.7403207554088,
	-21.8876023605551,-22.135292767562,-22.1905165190488,-22.6735184309858,
	-22.2316136658341,-23.0417642824639,-23.3675502112374,-23.9717909798426};

static const double DEFAULT_MAX_INTRON_LENGTH_SCORE = -11.4061953457637;
static const double MAX_DIFFERENCE_BETWEEN_ADJACENT_INTRON_SCORES = -1.7540191413836;
static const double DEFAULT_SCORE_GENOME_JUMP_BETA0 = -0.00034423061198151;
static const double DEFAULT_SCORE_GENOME_JUMP_BETA1 = -8.24709417318364;
static const double DEFAULT_SCORE_GENOME_JUMP_BETA2 = -2.22447084479731;
static const double DEFAULT_SCORE_GENOME_JUMP_BETA3 = -0.626060707646085;
static const double DEFAULT_SCORE_GENOME_JUMP_ALPHA = -0.329662144692664;
static const double DEFAULT_SCORE_GENOME_EXTENSION = -0.00394824611611598;
static const double DEFAULT_SCORE_CLONE_JUMP_BETA0 = -0.000229206;
static const double DEFAULT_SCORE_CLONE_JUMP_BETA1 = -8.71447;
static const double DEFAULT_SCORE_CLONE_JUMP_BETA2 = -1.93002;
static const double DEFAULT_SCORE_CLONE_JUMP_BETA3 = -0.835501;
static const double DEFAULT_SCORE_CLONE_JUMP_ALPHA = -0.302312;

static double max_difference_between_adjacent_intron_scores = MAX_DIFFERENCE_BETWEEN_ADJACENT_INTRON_SCORES;

static const double DEFAULT_MIN_DIFF_MISORIENTATION = -5.0;
static double min_diff_misorientation;

/* Control the initial number of defined positions  */
extern unsigned int init_cell_number_cutoff;
/* Control the number of defined positions occuring from locus extension */
extern unsigned int extension_cell_number_cutoff;
/* Control the number of defined positions occuring during retiling */
extern unsigned int inside_retiling_cell_number_cutoff;
                                                                                                                                       
/*******************************************************************************
Parameter declarations
*******************************************************************************/

extern unsigned int define_radius; /* diagonal endpoint extra defined positions
					(uses manhattan distance around each endpoint */
extern unsigned int retile_genomic_gap_lower_limit; /* gaps shorter than this
					will not be retiled */
extern unsigned int retile_genomic_gap_upper_limit; /* gaps longer than this
					will not be retiled */
extern unsigned int retile_poly_a_percentage; /*over this percentage,
					poly-a tails are not dynamically retiled */
extern unsigned int retile_tilesize; /* dynamic retile tilesize */
extern unsigned int retile_tileoverlay; /* dynamic retile tileoverlay */
extern unsigned int retile_exon_extension; /* dynamic retile exon extension gap limit */

static double score_match = DEFAULT_SCORE_MATCH - log(0.25); /* log(background probability of a match in alignment) */
static double score_mismatch = DEFAULT_SCORE_MISMATCH - log(3.0) - log(0.25); /* log(1.0 - score_match probability) */
static const double score_n_match = log(0.25) - log(0.25); /* log(average of possibilities) - log(0.25) */
#define DSS -4 * log(0.25) + DEFAULT_SCORE_SPLICE
static double score_splice[625] = { /* array of log(splice junction proability) */
	DSS[0],DSS[1],DSS[2],DSS[3],DSS[4],DSS[5],DSS[6],DSS[7],DSS[8],DSS[9],
	DSS[10],DSS[11],DSS[12],DSS[13],DSS[14],DSS[15],DSS[16],DSS[17],DSS[18],DSS[19],
	DSS[20],DSS[21],DSS[22],DSS[23],DSS[24],DSS[25],DSS[26],DSS[27],DSS[28],DSS[29],
	DSS[30],DSS[31],DSS[32],DSS[33],DSS[34],DSS[35],DSS[36],DSS[37],DSS[38],DSS[39],
	DSS[40],DSS[41],DSS[42],DSS[43],DSS[44],DSS[45],DSS[46],DSS[47],DSS[48],DSS[49],
	DSS[50],DSS[51],DSS[52],DSS[53],DSS[54],DSS[55],DSS[56],DSS[57],DSS[58],DSS[59],
	DSS[60],DSS[61],DSS[62],DSS[63],DSS[64],DSS[65],DSS[66],DSS[67],DSS[68],DSS[69],
	DSS[70],DSS[71],DSS[72],DSS[73],DSS[74],DSS[75],DSS[76],DSS[77],DSS[78],DSS[79],
	DSS[80],DSS[81],DSS[82],DSS[83],DSS[84],DSS[85],DSS[86],DSS[87],DSS[88],DSS[89],
	DSS[90],DSS[91],DSS[92],DSS[93],DSS[94],DSS[95],DSS[96],DSS[97],DSS[98],DSS[99],
	DSS[100],DSS[101],DSS[102],DSS[103],DSS[104],DSS[105],DSS[106],DSS[107],DSS[108],DSS[109],
	DSS[110],DSS[111],DSS[112],DSS[113],DSS[114],DSS[115],DSS[116],DSS[117],DSS[118],DSS[119],
	DSS[120],DSS[121],DSS[122],DSS[123],DSS[124],DSS[125],DSS[126],DSS[127],DSS[128],DSS[129],
	DSS[130],DSS[131],DSS[132],DSS[133],DSS[134],DSS[135],DSS[136],DSS[137],DSS[138],DSS[139],
	DSS[140],DSS[141],DSS[142],DSS[143],DSS[144],DSS[145],DSS[146],DSS[147],DSS[148],DSS[149],
	DSS[150],DSS[151],DSS[152],DSS[153],DSS[154],DSS[155],DSS[156],DSS[157],DSS[158],DSS[159],
	DSS[160],DSS[161],DSS[162],DSS[163],DSS[164],DSS[165],DSS[166],DSS[167],DSS[168],DSS[169],
	DSS[170],DSS[171],DSS[172],DSS[173],DSS[174],DSS[175],DSS[176],DSS[177],DSS[178],DSS[179],
	DSS[180],DSS[181],DSS[182],DSS[183],DSS[184],DSS[185],DSS[186],DSS[187],DSS[188],DSS[189],
	DSS[190],DSS[191],DSS[192],DSS[193],DSS[194],DSS[195],DSS[196],DSS[197],DSS[198],DSS[199],
	DSS[200],DSS[201],DSS[202],DSS[203],DSS[204],DSS[205],DSS[206],DSS[207],DSS[208],DSS[209],
	DSS[210],DSS[211],DSS[212],DSS[213],DSS[214],DSS[215],DSS[216],DSS[217],DSS[218],DSS[219],
	DSS[220],DSS[221],DSS[222],DSS[223],DSS[224],DSS[225],DSS[226],DSS[227],DSS[228],DSS[229],
	DSS[230],DSS[231],DSS[232],DSS[233],DSS[234],DSS[235],DSS[236],DSS[237],DSS[238],DSS[239],
	DSS[240],DSS[241],DSS[242],DSS[243],DSS[244],DSS[245],DSS[246],DSS[247],DSS[248],DSS[249],
	DSS[250],DSS[251],DSS[252],DSS[253],DSS[254],DSS[255],DSS[256],DSS[257],DSS[258],DSS[259],
	DSS[260],DSS[261],DSS[262],DSS[263],DSS[264],DSS[265],DSS[266],DSS[267],DSS[268],DSS[269],
	DSS[270],DSS[271],DSS[272],DSS[273],DSS[274],DSS[275],DSS[276],DSS[277],DSS[278],DSS[279],
	DSS[280],DSS[281],DSS[282],DSS[283],DSS[284],DSS[285],DSS[286],DSS[287],DSS[288],DSS[289],
	DSS[290],DSS[291],DSS[292],DSS[293],DSS[294],DSS[295],DSS[296],DSS[297],DSS[298],DSS[299],
	DSS[300],DSS[301],DSS[302],DSS[303],DSS[304],DSS[305],DSS[306],DSS[307],DSS[308],DSS[309],
	DSS[310],DSS[311],DSS[312],DSS[313],DSS[314],DSS[315],DSS[316],DSS[317],DSS[318],DSS[319],
	DSS[320],DSS[321],DSS[322],DSS[323],DSS[324],DSS[325],DSS[326],DSS[327],DSS[328],DSS[329],
	DSS[330],DSS[331],DSS[332],DSS[333],DSS[334],DSS[335],DSS[336],DSS[337],DSS[338],DSS[339],
	DSS[340],DSS[341],DSS[342],DSS[343],DSS[344],DSS[345],DSS[346],DSS[347],DSS[348],DSS[349],
	DSS[350],DSS[351],DSS[352],DSS[353],DSS[354],DSS[355],DSS[356],DSS[357],DSS[358],DSS[359],
	DSS[360],DSS[361],DSS[362],DSS[363],DSS[364],DSS[365],DSS[366],DSS[367],DSS[368],DSS[369],
	DSS[370],DSS[371],DSS[372],DSS[373],DSS[374],DSS[375],DSS[376],DSS[377],DSS[378],DSS[379],
	DSS[380],DSS[381],DSS[382],DSS[383],DSS[384],DSS[385],DSS[386],DSS[387],DSS[388],DSS[389],
	DSS[390],DSS[391],DSS[392],DSS[393],DSS[394],DSS[395],DSS[396],DSS[397],DSS[398],DSS[399],
	DSS[400],DSS[401],DSS[402],DSS[403],DSS[404],DSS[405],DSS[406],DSS[407],DSS[408],DSS[409],
	DSS[410],DSS[411],DSS[412],DSS[413],DSS[414],DSS[415],DSS[416],DSS[417],DSS[418],DSS[419],
	DSS[420],DSS[421],DSS[422],DSS[423],DSS[424],DSS[425],DSS[426],DSS[427],DSS[428],DSS[429],
	DSS[430],DSS[431],DSS[432],DSS[433],DSS[434],DSS[435],DSS[436],DSS[437],DSS[438],DSS[439],
	DSS[440],DSS[441],DSS[442],DSS[443],DSS[444],DSS[445],DSS[446],DSS[447],DSS[448],DSS[449],
	DSS[450],DSS[451],DSS[452],DSS[453],DSS[454],DSS[455],DSS[456],DSS[457],DSS[458],DSS[459],
	DSS[460],DSS[461],DSS[462],DSS[463],DSS[464],DSS[465],DSS[466],DSS[467],DSS[468],DSS[469],
	DSS[470],DSS[471],DSS[472],DSS[473],DSS[474],DSS[475],DSS[476],DSS[477],DSS[478],DSS[479],
	DSS[480],DSS[481],DSS[482],DSS[483],DSS[484],DSS[485],DSS[486],DSS[487],DSS[488],DSS[489],
	DSS[490],DSS[491],DSS[492],DSS[493],DSS[494],DSS[495],DSS[496],DSS[497],DSS[498],DSS[499],
	DSS[500],DSS[501],DSS[502],DSS[503],DSS[504],DSS[505],DSS[506],DSS[507],DSS[508],DSS[509],
	DSS[510],DSS[511],DSS[512],DSS[513],DSS[514],DSS[515],DSS[516],DSS[517],DSS[518],DSS[519],
	DSS[520],DSS[521],DSS[522],DSS[523],DSS[524],DSS[525],DSS[526],DSS[527],DSS[528],DSS[529],
	DSS[530],DSS[531],DSS[532],DSS[533],DSS[534],DSS[535],DSS[536],DSS[537],DSS[538],DSS[539],
	DSS[540],DSS[541],DSS[542],DSS[543],DSS[544],DSS[545],DSS[546],DSS[547],DSS[548],DSS[549],
	DSS[550],DSS[551],DSS[552],DSS[553],DSS[554],DSS[555],DSS[556],DSS[557],DSS[558],DSS[559],
	DSS[560],DSS[561],DSS[562],DSS[563],DSS[564],DSS[565],DSS[566],DSS[567],DSS[568],DSS[569],
	DSS[570],DSS[571],DSS[572],DSS[573],DSS[574],DSS[575],DSS[576],DSS[577],DSS[578],DSS[579],
	DSS[580],DSS[581],DSS[582],DSS[583],DSS[584],DSS[585],DSS[586],DSS[587],DSS[588],DSS[589],
	DSS[590],DSS[591],DSS[592],DSS[593],DSS[594],DSS[595],DSS[596],DSS[597],DSS[598],DSS[599],
	DSS[600],DSS[601],DSS[602],DSS[603],DSS[604],DSS[605],DSS[606],DSS[607],DSS[608],DSS[609],
	DSS[610],DSS[611],DSS[612],DSS[613],DSS[614],DSS[615],DSS[616],DSS[617],DSS[618],DSS[619],
	DSS[620],DSS[621],DSS[622],DSS[623],DSS[624]};
#undef DSS
static double max_splice_score = DEFAULT_MAX_SPLICE_SCORE - (4*log(0.25));
static double max_intron_length_score = DEFAULT_MAX_INTRON_LENGTH_SCORE;
static double ideal_intron_score = max_splice_score + max_intron_length_score;
/* genome jump score curve parameters */
static double score_genome_jump_beta0 = DEFAULT_SCORE_GENOME_JUMP_BETA0;
static double score_genome_jump_beta1 = DEFAULT_SCORE_GENOME_JUMP_BETA1;
static double score_genome_jump_beta2 = DEFAULT_SCORE_GENOME_JUMP_BETA2;
static double score_genome_jump_beta3 = DEFAULT_SCORE_GENOME_JUMP_BETA3;
static double score_genome_jump_alpha = DEFAULT_SCORE_GENOME_JUMP_ALPHA;
/* genome "no intron" extension score */
static double score_genome_extension = DEFAULT_SCORE_GENOME_EXTENSION;
/* clone jump score curve parameters */
static double score_clone_jump_beta0 = DEFAULT_SCORE_CLONE_JUMP_BETA0;
static double score_clone_jump_beta1 = DEFAULT_SCORE_CLONE_JUMP_BETA1;
static double score_clone_jump_beta2 = DEFAULT_SCORE_CLONE_JUMP_BETA2;
static double score_clone_jump_beta3 = DEFAULT_SCORE_CLONE_JUMP_BETA3;
static double score_clone_jump_alpha = DEFAULT_SCORE_CLONE_JUMP_ALPHA;

unsigned int get_size(diagSeg *d, unsigned int t) {
         unsigned int tmp = 0;
	 unsigned int e = (3*t)/2;
	 e = (2*define_radius+1)*e + define_radius*(define_radius-1);
         while (d != 0) {
                tmp += d->qEnd - d->qStart + 1 + e;
                d = d->next;
         }
         return tmp; 
}

/*******************************************************************************
jump scoring arrays and functions
*******************************************************************************/

#define SCORE_GENOME_JUMP_HARD_POINTS 4
static const double score_genome_jump[SCORE_GENOME_JUMP_HARD_POINTS] = {
	score_genome_jump_beta0, /* no jump */
	score_genome_jump_beta0 + score_genome_jump_beta1,
	score_genome_jump_beta0 + score_genome_jump_beta1 + score_genome_jump_beta2,
	score_genome_jump_beta0 + score_genome_jump_beta1 + score_genome_jump_beta2 + score_genome_jump_beta3};

static double score_genome_error_jump(unsigned int len) {
	if (len < SCORE_GENOME_JUMP_HARD_POINTS) {
		return score_genome_jump[len];
	} else {
		return score_genome_jump[SCORE_GENOME_JUMP_HARD_POINTS - 1] +
			(len - SCORE_GENOME_JUMP_HARD_POINTS + 1) * score_genome_jump_alpha;
	}
}

static const char N2CHAR[5] = {'t', 'c', 'a', 'g', 'n'};

#define SCORE_CLONE_JUMP_HARD_POINTS 4
static const double score_clone_jump[SCORE_CLONE_JUMP_HARD_POINTS] = {
	score_clone_jump_beta0, /* no jump */
	score_clone_jump_beta0 + score_clone_jump_beta1,
	score_clone_jump_beta0 + score_clone_jump_beta1 + score_clone_jump_beta2,
	score_clone_jump_beta0 + score_clone_jump_beta1 + score_clone_jump_beta2 + score_clone_jump_beta3};

static double score_clone_error_jump(unsigned int size) {
	if (size < SCORE_CLONE_JUMP_HARD_POINTS) return score_clone_jump[size];
	return score_clone_jump[SCORE_CLONE_JUMP_HARD_POINTS - 1] +
			(size - SCORE_CLONE_JUMP_HARD_POINTS + 1) * score_clone_jump_alpha;
}

#define JMAX(x,y) (((x)>(y)) ? (x) : (y))

static double ideal_gap_score[2] = {0, 0};
static double jumps_score_upper_limit[4] = {0, 0, 0, 0};

static void set_jumps_score_upper_limit()
{
       ideal_gap_score[0] = score_genome_jump[0]+JMAX(ideal_intron_score, score_genome_extension);
       ideal_gap_score[1] = JMAX(ideal_intron_score+score_genome_jump[0], score_genome_extension+score_genome_jump[1]);
       double tau[2][4] = {{0, 0, 0, 0}, {0, 0, 0, 0}};
      
              tau[0][0] = 2*score_clone_error_jump(0)-score_clone_error_jump(1);
              tau[0][1] = score_clone_error_jump(0)-score_clone_error_jump(2)+score_clone_error_jump(1);
              tau[0][2] = score_clone_error_jump(0)-score_clone_error_jump(3)+score_clone_error_jump(2);
              tau[0][3] = score_clone_error_jump(0)-score_clone_error_jump(4)+score_clone_error_jump(3);
              tau[1][0] = score_clone_error_jump(0)+JMAX(JMAX(score_clone_error_jump(1)-score_clone_error_jump(2),
                               score_clone_error_jump(2)-score_clone_error_jump(3)),
                               score_clone_error_jump(3)-score_clone_error_jump(4));
              tau[1][1] = score_clone_error_jump(1)+JMAX(JMAX(score_clone_error_jump(1)-score_clone_error_jump(3),
                               score_clone_error_jump(2)-score_clone_error_jump(4)),
                               score_clone_error_jump(3)-score_clone_error_jump(5));
              tau[1][2] = score_clone_error_jump(2)+JMAX(JMAX(score_clone_error_jump(1)-score_clone_error_jump(4),
                               score_clone_error_jump(2)-score_clone_error_jump(5)),
                               score_clone_error_jump(3)-score_clone_error_jump(6));
              tau[1][3] = score_clone_error_jump(3)+JMAX(JMAX(score_clone_error_jump(1)-score_clone_error_jump(5),
                               score_clone_error_jump(2)-score_clone_error_jump(6)),
                               score_clone_error_jump(3)-score_clone_error_jump(7));

              jumps_score_upper_limit[0] = JMAX(tau[0][0]+ideal_gap_score[1], tau[1][0]+ideal_gap_score[0]);
              jumps_score_upper_limit[1] = JMAX(tau[0][1]+ideal_gap_score[1], tau[1][1]+ideal_gap_score[0]);
              jumps_score_upper_limit[2] = JMAX(tau[0][2]+ideal_gap_score[1], tau[1][2]+ideal_gap_score[0]);
              jumps_score_upper_limit[3] = JMAX(tau[0][3]+ideal_gap_score[1], tau[1][3]+ideal_gap_score[0]); 
}
#undef JMAX

/*******************************************************************************
Parameter File Parsing Code
*******************************************************************************/

int setParametersFromFile(char *filename)
{
	SpaParameters parameters;
	int result = getParametersFromFile(&parameters, filename);
	if (result != PARAM_SUCCESS) return result;
	result = setParametersFromStruct(&parameters);
	if (result != PARAM_SUCCESS) return result;
	return PARAM_SUCCESS;
}

static void getLineFromFile(char *buffer, unsigned int buffer_size, FILE *fin)
{
	int cbuf;
	while (buffer_size > 1) {
		cbuf = fgetc(fin);
		if (cbuf == EOF || cbuf == '\n') {
			*buffer = '\0';
			return;
		}
		*buffer++ = (char)cbuf;
		buffer_size--;
	}
	*buffer = '\0';
	/* throw away any extra characters on long line */
	while (!feof(fin) && fgetc(fin) != '\n');
}

enum SpliceScoreParmConstants {
	FIRST_SPLICE_PARM = 4,
	NUM_SPLICE_PARMS = 256
};

static unsigned int num_intron = 0;

bool getParameter(SpaParameters *parameters, char *pname, char *pvalue)
{
	static const int number_of_integer_parameters = 2;
	static const char *parametername[] = {
		/* integer valued parameters */
		"shortest_intron_length",
		"longest_intron_length",
		/* double valued parameters */
		"score_match",
		"score_mismatch",
		"score_splice_tttt","score_splice_tttc","score_splice_ttta","score_splice_tttg",
		"score_splice_ttct","score_splice_ttcc","score_splice_ttca","score_splice_ttcg",
		"score_splice_ttat","score_splice_ttac","score_splice_ttaa","score_splice_ttag",
		"score_splice_ttgt","score_splice_ttgc","score_splice_ttga","score_splice_ttgg",
		"score_splice_tctt","score_splice_tctc","score_splice_tcta","score_splice_tctg",
		"score_splice_tcct","score_splice_tccc","score_splice_tcca","score_splice_tccg",
		"score_splice_tcat","score_splice_tcac","score_splice_tcaa","score_splice_tcag",
		"score_splice_tcgt","score_splice_tcgc","score_splice_tcga","score_splice_tcgg",
		"score_splice_tatt","score_splice_tatc","score_splice_tata","score_splice_tatg",
		"score_splice_tact","score_splice_tacc","score_splice_taca","score_splice_tacg",
		"score_splice_taat","score_splice_taac","score_splice_taaa","score_splice_taag",
		"score_splice_tagt","score_splice_tagc","score_splice_taga","score_splice_tagg",
		"score_splice_tgtt","score_splice_tgtc","score_splice_tgta","score_splice_tgtg",
		"score_splice_tgct","score_splice_tgcc","score_splice_tgca","score_splice_tgcg",
		"score_splice_tgat","score_splice_tgac","score_splice_tgaa","score_splice_tgag",
		"score_splice_tggt","score_splice_tggc","score_splice_tgga","score_splice_tggg",
		"score_splice_cttt","score_splice_cttc","score_splice_ctta","score_splice_cttg",
		"score_splice_ctct","score_splice_ctcc","score_splice_ctca","score_splice_ctcg",
		"score_splice_ctat","score_splice_ctac","score_splice_ctaa","score_splice_ctag",
		"score_splice_ctgt","score_splice_ctgc","score_splice_ctga","score_splice_ctgg",
		"score_splice_cctt","score_splice_cctc","score_splice_ccta","score_splice_cctg",
		"score_splice_ccct","score_splice_cccc","score_splice_ccca","score_splice_cccg",
		"score_splice_ccat","score_splice_ccac","score_splice_ccaa","score_splice_ccag",
		"score_splice_ccgt","score_splice_ccgc","score_splice_ccga","score_splice_ccgg",
		"score_splice_catt","score_splice_catc","score_splice_cata","score_splice_catg",
		"score_splice_cact","score_splice_cacc","score_splice_caca","score_splice_cacg",
		"score_splice_caat","score_splice_caac","score_splice_caaa","score_splice_caag",
		"score_splice_cagt","score_splice_cagc","score_splice_caga","score_splice_cagg",
		"score_splice_cgtt","score_splice_cgtc","score_splice_cgta","score_splice_cgtg",
		"score_splice_cgct","score_splice_cgcc","score_splice_cgca","score_splice_cgcg",
		"score_splice_cgat","score_splice_cgac","score_splice_cgaa","score_splice_cgag",
		"score_splice_cggt","score_splice_cggc","score_splice_cgga","score_splice_cggg",
		"score_splice_attt","score_splice_attc","score_splice_atta","score_splice_attg",
		"score_splice_atct","score_splice_atcc","score_splice_atca","score_splice_atcg",
		"score_splice_atat","score_splice_atac","score_splice_ataa","score_splice_atag",
		"score_splice_atgt","score_splice_atgc","score_splice_atga","score_splice_atgg",
		"score_splice_actt","score_splice_actc","score_splice_acta","score_splice_actg",
		"score_splice_acct","score_splice_accc","score_splice_acca","score_splice_accg",
		"score_splice_acat","score_splice_acac","score_splice_acaa","score_splice_acag",
		"score_splice_acgt","score_splice_acgc","score_splice_acga","score_splice_acgg",
		"score_splice_aatt","score_splice_aatc","score_splice_aata","score_splice_aatg",
		"score_splice_aact","score_splice_aacc","score_splice_aaca","score_splice_aacg",
		"score_splice_aaat","score_splice_aaac","score_splice_aaaa","score_splice_aaag",
		"score_splice_aagt","score_splice_aagc","score_splice_aaga","score_splice_aagg",
		"score_splice_agtt","score_splice_agtc","score_splice_agta","score_splice_agtg",
		"score_splice_agct","score_splice_agcc","score_splice_agca","score_splice_agcg",
		"score_splice_agat","score_splice_agac","score_splice_agaa","score_splice_agag",
		"score_splice_aggt","score_splice_aggc","score_splice_agga","score_splice_aggg",
		"score_splice_gttt","score_splice_gttc","score_splice_gtta","score_splice_gttg",
		"score_splice_gtct","score_splice_gtcc","score_splice_gtca","score_splice_gtcg",
		"score_splice_gtat","score_splice_gtac","score_splice_gtaa","score_splice_gtag",
		"score_splice_gtgt","score_splice_gtgc","score_splice_gtga","score_splice_gtgg",
		"score_splice_gctt","score_splice_gctc","score_splice_gcta","score_splice_gctg",
		"score_splice_gcct","score_splice_gccc","score_splice_gcca","score_splice_gccg",
		"score_splice_gcat","score_splice_gcac","score_splice_gcaa","score_splice_gcag",
		"score_splice_gcgt","score_splice_gcgc","score_splice_gcga","score_splice_gcgg",
		"score_splice_gatt","score_splice_gatc","score_splice_gata","score_splice_gatg",
		"score_splice_gact","score_splice_gacc","score_splice_gaca","score_splice_gacg",
		"score_splice_gaat","score_splice_gaac","score_splice_gaaa","score_splice_gaag",
		"score_splice_gagt","score_splice_gagc","score_splice_gaga","score_splice_gagg",
		"score_splice_ggtt","score_splice_ggtc","score_splice_ggta","score_splice_ggtg",
		"score_splice_ggct","score_splice_ggcc","score_splice_ggca","score_splice_ggcg",
		"score_splice_ggat","score_splice_ggac","score_splice_ggaa","score_splice_ggag",
		"score_splice_gggt","score_splice_gggc","score_splice_ggga","score_splice_gggg",
		"min_diff_misorientation",
		"score_genome_jump_beta0",
		"score_genome_jump_beta1",
		"score_genome_jump_beta2",
		"score_genome_jump_beta3",
		"score_genome_jump_alpha",
		"score_genome_extension",
		"score_clone_jump_beta0",
		"score_clone_jump_beta1",
		"score_clone_jump_beta2",
		"score_clone_jump_beta3",
		"score_clone_jump_alpha",
		"score_intron"
	};
	int number_of_parameters = sizeof(parametername) / sizeof(parametername[0]);
	int p_index;
	for (p_index = 0; p_index < number_of_parameters; p_index++) {
		if (strcmp(pname,parametername[p_index]) == 0) {
			unsigned int int_value;
			double double_value;
			int result;
			if (p_index < number_of_integer_parameters) {
				result = sscanf(pvalue,"%u",&int_value);
			} else {
				result = sscanf(pvalue,"%lf",&double_value);
			}
			if (result != 1) return false; /* bad value */
			if (p_index >= FIRST_SPLICE_PARM && p_index < FIRST_SPLICE_PARM+NUM_SPLICE_PARMS) {
				parameters->score_splice[p_index-FIRST_SPLICE_PARM] = log(double_value);
				return true;
			}
			switch (p_index) {
			case 0: parameters->shortest_intron_length = int_value; return true;
			case 1: parameters->longest_intron_length = int_value; return true;
			case 2: parameters->score_match = log(double_value); return true;
			case 3: parameters->score_mismatch = log(double_value); return true;
			case 4+NUM_SPLICE_PARMS: parameters->min_diff_misorientation = double_value; return true;
			case 5+NUM_SPLICE_PARMS: parameters->score_genome_jump_beta0 = double_value; return true;
			case 6+NUM_SPLICE_PARMS: parameters->score_genome_jump_beta1 = double_value; return true;
			case 7+NUM_SPLICE_PARMS: parameters->score_genome_jump_beta2 = double_value; return true;
			case 8+NUM_SPLICE_PARMS: parameters->score_genome_jump_beta3 = double_value; return true;
			case 9+NUM_SPLICE_PARMS: parameters->score_genome_jump_alpha = double_value; return true;
			case 10+NUM_SPLICE_PARMS: parameters->score_genome_extension = double_value; return true;
			case 11+NUM_SPLICE_PARMS: parameters->score_clone_jump_beta0 = double_value; return true;
			case 12+NUM_SPLICE_PARMS: parameters->score_clone_jump_beta1 = double_value; return true;
			case 13+NUM_SPLICE_PARMS: parameters->score_clone_jump_beta2 = double_value; return true;
			case 14+NUM_SPLICE_PARMS: parameters->score_clone_jump_beta3 = double_value; return true;
			case 15+NUM_SPLICE_PARMS: parameters->score_clone_jump_alpha = double_value; return true;
			case 16+NUM_SPLICE_PARMS: parameters->score_intron[num_intron++] = double_value; return true;
			}
			return false; /* logical error */
		}
	}
	/* could not find parameter name in list */
	return false;
}

int getParametersFromFile(SpaParameters *parameters, char *filename)
{
	if (parameters == 0) return PARAM_INVALIDPOINTER_ERROR;
	/* set parameters to defaults (except score_splice elements) */
	parameters->shortest_intron_length = DEFAULT_SHORTEST_INTRON_LENGTH_IN_TABLE;
	parameters->longest_intron_length = DEFAULT_LONGEST_INTRON_LENGTH_IN_TABLE;
	parameters->score_match = DBL_MAX;
	parameters->score_mismatch = DBL_MAX;
	parameters->min_diff_misorientation = DEFAULT_MIN_DIFF_MISORIENTATION;
	int index;
	for (index = 0; index < 256; index++) {
		parameters->score_splice[index] = DBL_MAX;
	}
	parameters->score_genome_jump_beta0 = DEFAULT_SCORE_GENOME_JUMP_BETA0;
	parameters->score_genome_jump_beta1 = DEFAULT_SCORE_GENOME_JUMP_BETA1;
	parameters->score_genome_jump_beta2 = DEFAULT_SCORE_GENOME_JUMP_BETA2;
	parameters->score_genome_jump_beta3 = DEFAULT_SCORE_GENOME_JUMP_BETA3;
	parameters->score_genome_jump_alpha = DEFAULT_SCORE_GENOME_JUMP_ALPHA;
	parameters->score_genome_extension = DEFAULT_SCORE_GENOME_EXTENSION;
	parameters->score_clone_jump_beta0 = DEFAULT_SCORE_CLONE_JUMP_BETA0;
	parameters->score_clone_jump_beta1 = DEFAULT_SCORE_CLONE_JUMP_BETA1;
	parameters->score_clone_jump_beta2 = DEFAULT_SCORE_CLONE_JUMP_BETA2;
	parameters->score_clone_jump_beta3 = DEFAULT_SCORE_CLONE_JUMP_BETA3;
	parameters->score_clone_jump_alpha = DEFAULT_SCORE_CLONE_JUMP_ALPHA;
	/* read parameter values from file */
	if (filename == 0) return PARAM_FILENAME_ERROR;
	FILE *fin = fopen(filename, "r");
	if (!fin) return PARAM_FILENAME_ERROR;
	while (!feof(fin)) {
		char pline[512];
		char pname[256];
		char pvalue[256];
		getLineFromFile(pline,512,fin);
		int result = sscanf(pline,"%255s%255s",pname,pvalue);
		if (pname[0] == '#') continue; /* ignore comment lines */
		if (result == 0) continue; /* ignore blank lines */
		if (result == -1) continue; 
		if (result == 1 || !getParameter(parameters,pname,pvalue)) {
			fprintf(stderr,"Error while parsing parameter file on line:\n%s\n", pline);
			return PARAM_CORRUPTFILE_ERROR;
		}
	}
	fclose(fin);
	/* adjust probability sums */
	if (parameters->score_match == DBL_MAX && parameters->score_mismatch == DBL_MAX) {
		score_match = DEFAULT_SCORE_MATCH;
		score_mismatch = DEFAULT_SCORE_MISMATCH;
	} else if (parameters->score_match == DBL_MAX) {
		score_match = log(1.0 - exp(score_mismatch));
	} else if (parameters->score_mismatch == DBL_MAX) {
		score_mismatch = log(1.0 - exp(score_match));
	}
	/* balance splice scores */
	int balance_count = 0;
	double total_prob = 1.0;
	for (index = 0; index < 256; index++) {
		if (parameters->score_splice[index] == DBL_MAX) balance_count++;
		else total_prob -= exp(parameters->score_splice[index]);
	}
	if (balance_count > 0) {
		double balance_score = total_prob / balance_count;
		for (index = 0; index < 256; index++) {
			if (parameters->score_splice[index] == DBL_MAX) {
				parameters->score_splice[index] = log(balance_score);
			}
		}
	}
	return PARAM_SUCCESS;
}

int setScoreIntron(const double *p_score_intron) {
	unsigned int index;
	double tmp;
	for (index = 0; index < num_intron; index++) {
		score_intron_length_table[index] = p_score_intron[index];
	}
	if (num_intron > 0 && num_intron != SCORE_INTRON_LENGTH_TABLE_SIZE) {
		return PARAM_INTRON_NUMBER_ERROR;
	}
	if (num_intron > 0) {
		max_intron_length_score = score_intron_length_table[0];
		max_difference_between_adjacent_intron_scores = -DBL_MAX;	
		for (index = 1; index < num_intron; index++) {
			if (max_intron_length_score < score_intron_length_table[index])
                		max_intron_length_score = score_intron_length_table[index];
				tmp = score_intron_length_table[index]-score_intron_length_table[index-1];
				tmp = (tmp > 0.0) ? tmp : -tmp;
			if (tmp > max_difference_between_adjacent_intron_scores)
				max_difference_between_adjacent_intron_scores = tmp;
		}
		max_difference_between_adjacent_intron_scores = -max_difference_between_adjacent_intron_scores;
        }
	return PARAM_SUCCESS;
}

void setScoreSplice(const double *p_score_splice)
{
	int index;
	for (index = 0; index < 625; index++) {
		score_splice[index] = 0.0;
	}
	for (index = 0; index < 256; index++) {
		int leftout = index % 4;
		int leftin = (index / 4) % 4;
		int rightin = (index / 16) % 4;
		int rightout = index / 64;
		/* set direct score */
		score_splice[rightout * 125 + rightin * 25 + leftin * 5 + leftout] = p_score_splice[index];
		/* accumulate "unknown N" probabilities */
		double probability = exp(p_score_splice[index]);
		score_splice[rightout * 125 + rightin * 25 + leftin * 5 + 4] += probability;
		score_splice[rightout * 125 + rightin * 25 + 4 * 5 + leftout] += probability;
		score_splice[rightout * 125 + rightin * 25 + 4 * 5 + 4] += probability;
		score_splice[rightout * 125 + 4 * 25 + leftin * 5 + leftout] += probability;
		score_splice[rightout * 125 + 4 * 25 + leftin * 5 + 4] += probability;
		score_splice[rightout * 125 + 4 * 25 + 4 * 5 + leftout] += probability;
		score_splice[rightout * 125 + 4 * 25 + 4 * 5 + 4] += probability;
		score_splice[4 * 125 + rightin * 25 + leftin * 5 + leftout] += probability;
		score_splice[4 * 125 + rightin * 25 + leftin * 5 + 4] += probability;
		score_splice[4 * 125 + rightin * 25 + 4 * 5 + leftout] += probability;
		score_splice[4 * 125 + rightin * 25 + 4 * 5 + 4] += probability;
		score_splice[4 * 125 + 4 * 25 + leftin * 5 + leftout] += probability;
		score_splice[4 * 125 + 4 * 25 + leftin * 5 + 4] += probability;
		score_splice[4 * 125 + 4 * 25 + 4 * 5 + leftout] += probability;
		score_splice[4 * 125 + 4 * 25 + 4 * 5 + 4] += probability;
	}
	/* average logs */
	for (index = 0; index < 625; index++) {
		int leftout = index % 5;
		int leftin = (index / 5) % 5;
		int rightin = (index / 25) % 5;
		int rightout = index / 125;
		int ncount = 0;
		if (leftout == 4) ncount++;
		if (leftin == 4) ncount++;
		if (rightin == 4) ncount++;
		if (rightout == 4) ncount++;
		switch (ncount) {
		case 1:
			score_splice[index] = log(score_splice[index]) - log(4.0);
			break;
		case 2:
			score_splice[index] = log(score_splice[index]) - log(16.0);
			break;
		case 3:
			score_splice[index] = log(score_splice[index]) - log(64.0);
			break;
		case 4:
			score_splice[index] = log(score_splice[index]) - log(256.0);
			break;
		default:
			/* no "N" involved */
			break;
		}
		/* adjust for observing the 4 bases in the junction */
		score_splice[index] -= 4 * log(0.25);
	}
	/* set max_splice_score */
	max_splice_score = score_splice[0];
	for (index = 1; index < 625; index++) {
		if (score_splice[index] > max_splice_score) max_splice_score = score_splice[index];
	}
	ideal_intron_score = max_splice_score + max_intron_length_score;
}

int setParametersFromStruct(SpaParameters *parameters)
{
	if (parameters == 0) return PARAM_INVALIDPOINTER_ERROR;
	double probability_err = 1.0 - exp(parameters->score_match) - exp(parameters->score_mismatch);
	if (probability_err < 0.0) probability_err = - probability_err;
	if (probability_err > 0.0001) return PARAM_INCONSISTANTPROBABILITY_ERROR;
	probability_err = 1.0;
	int index;
	for (index = 0; index < 256; index++) probability_err -= exp(parameters->score_splice[index]);
	if (probability_err < 0.0) probability_err = - probability_err;
	if (probability_err > 0.0001) return PARAM_INCONSISTANTPROBABILITY_ERROR;
	probability_err = 1.0 - exp(parameters->score_genome_extension);
	if (probability_err < 0.0 || probability_err > 1.0) return PARAM_INCONSISTANTPROBABILITY_ERROR;
	if (parameters->shortest_intron_length != DEFAULT_SHORTEST_INTRON_LENGTH_IN_TABLE) {
		shortest_intron_length_in_table	= parameters->shortest_intron_length;
		minimum_intron_length_possible	= shortest_intron_length_in_table;
	}
	if (parameters->longest_intron_length != DEFAULT_LONGEST_INTRON_LENGTH_IN_TABLE) 
		longest_intron_length_in_table = parameters->longest_intron_length;
	intron_bin_log_step = log((longest_intron_length_in_table + 1.0)/shortest_intron_length_in_table)/SCORE_INTRON_LENGTH_TABLE_SIZE; 
	score_match = parameters->score_match - log(0.25);
	score_mismatch = parameters->score_mismatch - log(3.0) - log(0.25);
	if (setScoreIntron(parameters->score_intron) != PARAM_SUCCESS) return PARAM_INTRON_NUMBER_ERROR;
	setScoreSplice(parameters->score_splice);
	setScoreIntron(parameters->score_intron);
	score_genome_jump_beta0 = parameters->score_genome_jump_beta0;
	if (parameters->score_genome_jump_beta1 > max_difference_between_adjacent_intron_scores) {
		fprintf(stderr,"Error: score_genome_jump_beta0 parameter is less negative than the\n");
		fprintf(stderr,"       largest drop in intron length score between two adjacent score\n");
		fprintf(stderr,"       buckets. The intron search algorithm is invalid under these\n");
		fprintf(stderr,"       conditions. (largest drop = %20.20f)\n",max_difference_between_adjacent_intron_scores);
		return PARAM_INCONSISTANTPROBABILITY_ERROR;
	}
	score_genome_jump_beta1 = parameters->score_genome_jump_beta1;
	score_genome_jump_beta2 = parameters->score_genome_jump_beta2;
	score_genome_jump_beta3 = parameters->score_genome_jump_beta3;
	score_genome_jump_alpha = parameters->score_genome_jump_alpha;
	score_clone_jump_beta0 = parameters->score_clone_jump_beta0;
	score_clone_jump_beta1 = parameters->score_clone_jump_beta1;
	score_clone_jump_beta2 = parameters->score_clone_jump_beta2;
	score_clone_jump_beta3 = parameters->score_clone_jump_beta3;
	score_clone_jump_alpha = parameters->score_clone_jump_alpha;
	score_genome_extension = parameters->score_genome_extension;
	set_jumps_score_upper_limit();
	return PARAM_SUCCESS;
}

/*******************************************************************************
Spa Central Code
*******************************************************************************/

static double score_intron(char leftout, char leftin,
		char rightin, char rightout, bool reverse_junction_scoring, unsigned int len) {
	double length_score;
	if (len < shortest_intron_length_in_table) return log(0.0); /* small introns impossible */
	if (len >= longest_intron_length_in_table) {
		/* very very long introns have same score as last table score */
		length_score = score_intron_length_table[SCORE_INTRON_LENGTH_TABLE_SIZE - 1];
	} else {
		length_score = score_intron_length_table[(int)(log((1.0*len)/shortest_intron_length_in_table)/intron_bin_log_step)];
	}
	if (reverse_junction_scoring) {
		return score_splice[NT2CVAL[(int)rightout] * 125 +
			NT2CVAL[(int)rightin] * 25 +
			NT2CVAL[(int)leftin] * 5 +
			NT2CVAL[(int)leftout]] +
                        length_score;
	} else {
		return score_splice[NT2VAL[(int)leftout] * 125 +
			NT2VAL[(int)leftin] * 25 +
			NT2VAL[(int)rightin] * 5 +
			NT2VAL[(int)rightout]] +
                        length_score;
	}
}

static double score_genome_best_jump(const Locus *locus,
		unsigned int child_offset, unsigned int parent_offset,
		unsigned int *errors_left, unsigned int *errors_right,
		bool reverse_junction_scoring, double limit_score)
{
	child_offset -= locus->get_startOffset();
	parent_offset -= locus->get_startOffset();
#undef SHOW_INTRON_SEARCH
#ifdef SHOW_INTRON_SEARCH
printf("entry %u,%u\n",parent_offset,child_offset);
#endif
	const char *locus_dna = locus->get_dna();
	const double score_all_error = score_genome_error_jump(child_offset - parent_offset - 1) + score_genome_extension;
	if (child_offset - parent_offset <= minimum_intron_length_possible) {
		/* not enough to make intron */
#ifdef SHOW_INTRON_SEARCH
printf("all error! = %f\n", score_all_error);
#endif
		*errors_left = child_offset - parent_offset - 1;
		*errors_right = child_offset - parent_offset - 1;
		return score_all_error;
	}
	/* begin with all intron */
	unsigned int num_left_errors = 0;
	unsigned int num_right_errors = 0;
	unsigned int best_num_left_errors = 0;
	unsigned int best_num_right_errors = 0;
	double best_score_seen = score_genome_error_jump(0) +
			score_intron(
			locus_dna[parent_offset + 1],
			locus_dna[parent_offset + 2],
			locus_dna[child_offset - 2],
			locus_dna[child_offset - 1],
			reverse_junction_scoring, child_offset - parent_offset - 1);
#ifdef SHOW_INTRON_SEARCH
printf("start intron - %c%c%c%c  len: %u score:%f\n",
			locus_dna[parent_offset + 1],
			locus_dna[parent_offset + 2],
			locus_dna[child_offset - 2],
			locus_dna[child_offset - 1],
			child_offset - parent_offset - 1, best_score_seen);
int maxerrors = 0;
#endif
	/* search until errors outweigh best score seen so far (or score_limit) */
	for(;;) {
		num_left_errors = num_right_errors + 1; /* add one more error */
		num_right_errors = 0;
		const double error_jump_score = score_genome_error_jump(num_left_errors);
		const double upper_limit_score = error_jump_score + ideal_intron_score;
		/* TODO: instead of ideal_intron_score above, use a function which finds the ideal
		intron of size <= x -- use that as the best score for an intron */
		if (best_score_seen >= upper_limit_score) {
			/* no longer possible to find better score */
			break;
		}
		if (limit_score >= upper_limit_score) {
			/* no longer possible to exceed limit_score */
			break;
		}
#ifdef SHOW_INTRON_SEARCH
maxerrors = num_left_errors;
#endif
		if (child_offset - parent_offset - num_left_errors <= minimum_intron_length_possible) {
			if (score_all_error > best_score_seen) {
#ifdef SHOW_INTRON_SEARCH
printf("no good intron found, all error= %f\n", score_all_error);
#endif
				*errors_left = child_offset - parent_offset - 1;
				*errors_right = child_offset - parent_offset - 1;
				return score_all_error;
			} else {
#ifdef SHOW_INTRON_SEARCH
printf("best intron found= %f\n", best_score_seen);
#endif
				*errors_left = best_num_left_errors;
				*errors_right = best_num_right_errors;
				return best_score_seen;
			}
		}
		for (;;) {
			double scan_score = error_jump_score + score_intron(
					locus_dna[parent_offset + 1 + num_left_errors],
					locus_dna[parent_offset + 2 + num_left_errors],
					locus_dna[child_offset - 2 - num_right_errors],
					locus_dna[child_offset - 1 - num_right_errors],
					reverse_junction_scoring,
					child_offset - num_right_errors - parent_offset - num_left_errors - 1);
			if (scan_score > best_score_seen) {
				best_num_left_errors = num_left_errors;
				best_num_right_errors = num_right_errors;
				best_score_seen = scan_score;
#ifdef SHOW_INTRON_SEARCH
printf("better: %d gaps left %d gaps right (%f), intron: %c%c%c%c len: %u (%f) total: %f\n",
	num_left_errors, num_right_errors,
	score_genome_error_jump(num_left_errors + num_right_errors),
	locus_dna[parent_offset + 1 + num_left_errors],
	locus_dna[parent_offset + 2 + num_left_errors],
	locus_dna[child_offset - 2 - num_right_errors],
	locus_dna[child_offset - 1 - num_right_errors],
	child_offset - num_right_errors - parent_offset - num_left_errors - 1,
	score_intron(
		locus_dna[parent_offset + 1 + num_left_errors],
		locus_dna[parent_offset + 2 + num_left_errors],
		locus_dna[child_offset - 2 - num_right_errors],
		locus_dna[child_offset - 1 - num_right_errors],
		reverse_junction_scoring,
		child_offset - num_right_errors - parent_offset - num_left_errors - 1),
	best_score_seen);
#endif
			}
			if (num_left_errors == 0) break;
			num_left_errors--;
			num_right_errors++;
		}
	}
	if (score_all_error > best_score_seen) {
#ifdef SHOW_INTRON_SEARCH
printf("all error better than best intron = %f\n", score_all_error);
#endif
		*errors_left = child_offset - parent_offset - 1;
		*errors_right = child_offset - parent_offset - 1;
		return score_all_error;
	} else {
#ifdef SHOW_INTRON_SEARCH
printf("returned %f (max errors: %d)\n",best_score_seen,maxerrors);
#endif
		*errors_left = best_num_left_errors;
		*errors_right = best_num_right_errors;
		return best_score_seen;
	}
}

struct ColumnMajor : public binary_function<Cell,Cell,bool>
{
	bool operator() (const Cell *x, const Cell *y) const {
		if (x->genome_pos < y->genome_pos) return true;
		if (x->genome_pos > y->genome_pos) return false;
		if (x->clone_pos < y->clone_pos) return true;
		return false;
	}
};

struct ScoreOrder: public binary_function<Cell,Cell,bool>
{
	bool operator() (const Cell *x, const Cell *y) const {
		if (x->score > y->score) return true;
		return false;
	}
};

static set<Cell *, ColumnMajor> *grid;
static multiset<Cell *, ScoreOrder> *best_list;

static void gridAddDiagonal(int qStart, int tStart, int qEnd,
		const dnaSeq *querySequence, const Locus *locus)
{
	/* add positions along diagonal */
	for (;qStart <= qEnd;qStart++,tStart++) {
		if (qStart >= querySequence->size) return;
		if (tStart - (int)(locus->get_startOffset()) >= (int)(locus->get_size())) return;
		if (qStart < 0) continue;
		if (tStart < (int)(locus->get_startOffset())) continue;
		Cell *cell = new Cell;
		cell->parent = 0;
		cell->child = &no_child;
		cell->near_neighbour = 0;
		cell->clone_pos = qStart;
		cell->genome_pos = tStart;
		cell->gap_left = 0;
		cell->gap_right = 0;
		cell->clone_base = querySequence->dna[qStart];
		cell->genome_base = locus->get_dna()[tStart - locus->get_startOffset()];
		cell->score = 0.0;
		if ((grid->insert(cell)).second == false) {
			/* duplicate already in grid -- not inserted */
			delete cell;
		}
	}
}

  static void gridAddEndpointForward(int qStart, int tStart,
		                  const dnaSeq *querySequence, const Locus *locus)
{
	        int extend_len = (3*locus->get_tileSize())/2 + define_radius;
	        int cStart = qStart - define_radius;
	        int gStart = tStart - define_radius;
	        /* add along diagonal */
	        gridAddDiagonal(cStart, gStart, qStart + extend_len, querySequence, locus);
	        unsigned int x;
	        for (x = 1; x <= define_radius; x++) {
                /* upper flank */
                     gridAddDiagonal(cStart, gStart + x, qStart + extend_len - x, querySequence, locus);
                /* lower flank */
                     gridAddDiagonal(cStart + x, gStart, qStart + extend_len, querySequence, locus);
                }
}


static void gridAddEndpointBackward(int qStart, int tStart,
		                const dnaSeq *querySequence, const Locus *locus)
{
	        int extend_len = (3*locus->get_tileSize())/2 + define_radius;
	        int cStart = qStart - extend_len;
	        int gStart = tStart - extend_len;
	        /* add along diagonal */
                gridAddDiagonal(cStart, gStart, qStart + define_radius, querySequence, locus);
	        unsigned int x;
	        for (x = 1; x <= define_radius; x++) {
                /* upper flank */
                     gridAddDiagonal(cStart, gStart + x, qStart + define_radius - x, querySequence, locus);
                /* lower flank */
                     gridAddDiagonal(cStart + x, gStart, qStart + define_radius, querySequence, locus);
	        }
}


static void gridSetNearNeighbour()
{
	set<Cell *>::const_iterator scan_p_neighbour = grid->begin();
	set<Cell *>::const_iterator scan_c_neighbour = grid->begin();
	scan_c_neighbour++;
	while (scan_c_neighbour != grid->end()) {
		if ((*scan_p_neighbour)->genome_pos + 1 < (*scan_c_neighbour)->genome_pos) {
			scan_p_neighbour++;
			continue;
		}
		if ((*scan_p_neighbour)->genome_pos + 1 > (*scan_c_neighbour)->genome_pos) {
			scan_c_neighbour++;
			continue;
		}
		/* they are one column apart */
		if ((*scan_p_neighbour)->clone_pos + 1 < (*scan_c_neighbour)->clone_pos) {
			scan_p_neighbour++;
			continue;
		}
		if ((*scan_p_neighbour)->clone_pos + 1 > (*scan_c_neighbour)->clone_pos) {
			scan_c_neighbour++;
			continue;
		}
		/* they are one row apart - they are near neighbours */
		(*scan_c_neighbour)->near_neighbour = *scan_p_neighbour;
		scan_c_neighbour++;
		scan_p_neighbour++;
	}
}

static void cell_compute_score(Cell *cell, dnaSeq *querySequence, Locus *locus,
		bool reverse_junction_scoring, double no_parent_score)
{
       int pnum = 0;
#undef SHOW_PARENTSEARCH
#ifdef SHOW_PARENTSEARCH
int num_parents = 0;
printf("scoring cell: %d,%d\n",cell->clone_pos,cell->genome_pos);
#endif
	/* start with "no parent" case */
	cell->parent = 0;
	cell->gap_left = 0;
	cell->gap_right = 0;
	cell->score = no_parent_score;
        cell->score += score_genome_jump[0] + score_genome_extension; 
        cell->score += score_clone_error_jump(cell->clone_pos);
          
#ifdef SHOW_PARENTSEARCH
printf("no parent score: %f\n",cell->score);
#endif
	/* consider near neighbour first -- if existent */
	if (cell->near_neighbour) {
		const double nn_score = cell->near_neighbour->score +
			score_clone_error_jump(0) -
                        score_clone_error_jump(querySequence->size-cell->clone_pos) + 
			score_genome_error_jump(0) +
			score_genome_extension;
		if (nn_score > cell->score) {
			cell->parent = cell->near_neighbour;
			cell->score = nn_score;
#ifdef SHOW_PARENTSEARCH
printf("nearest neighbor better: %f\n",cell->score);
#endif
		}
	}
        cell->score += score_clone_error_jump(querySequence->size - cell->clone_pos - 1);
	/* consider other possible parents */
	multiset<Cell *>::const_iterator ci;
	for (ci = best_list->begin(); ci != best_list->end(); ci++) {
		if ((*ci)->genome_pos >= cell->genome_pos ||
				(*ci)->clone_pos >= cell->clone_pos) continue; /* filter non parents */
             pnum++;
#ifdef SHOW_PARENTSEARCH
num_parents++;
printf("considering parent: %u,%u : (p.sc.) %f\n",(*ci)->clone_pos, (*ci)->genome_pos, (*ci)->score);
#endif
                if (querySequence->size - cell->clone_pos <= 3) {
		    if (cell->score > (*ci)->score + jumps_score_upper_limit[querySequence->size - cell->clone_pos - 1]) 
		       	break; /* cut off */
                 }
                else {
                    if (cell->score > (*ci)->score + jumps_score_upper_limit[3]) 
                        break;
                }
		unsigned int errors_left;
		unsigned int errors_right;
		double score = (*ci)->score +
				score_clone_error_jump(cell->clone_pos - (*ci)->clone_pos - 1) - 
                                score_clone_error_jump(querySequence->size - (*ci)->clone_pos - 1);
                                score += score_clone_error_jump(querySequence->size - cell->clone_pos - 1);
                if (cell->genome_pos - (*ci)->genome_pos == 1) {
                    if (score + ideal_gap_score[0] < cell->score) 
                        continue;
                }
                else {
                    if (score + ideal_gap_score[1] < cell->score)
                        continue;
                }
		score += score_genome_best_jump(locus, cell->genome_pos, (*ci)->genome_pos,
				&errors_left, &errors_right, reverse_junction_scoring,
				cell->score - score);
               
#ifdef SHOW_PARENTSEARCH
printf("effective score : %f\n", score);
printf("\t%f  %f (L %i R %i)\n", score_clone_error_jump(cell->clone_pos - (*ci)->clone_pos - 1),
				score_genome_best_jump(locus, cell->genome_pos, (*ci)->genome_pos,
                                &errors_left, &errors_right, reverse_junction_scoring,
                                cell->score - score), errors_left, errors_right);
#endif
		if (score > cell->score) {
#ifdef SHOW_PARENTSEARCH
printf("better parent: %u,%u : %f\n",(*ci)->clone_pos, (*ci)->genome_pos, score);
printf("\t%f  %f\n", score_clone_error_jump(cell->clone_pos - (*ci)->clone_pos - 1),
				score_genome_best_jump(locus, cell->genome_pos, (*ci)->genome_pos,
                                &errors_left, &errors_right, reverse_junction_scoring,
                                cell->score - score));
#endif
			cell->gap_left = errors_left;
			cell->gap_right = errors_right;
			cell->score = score;
			cell->parent = *ci;
		}
	}
	if (NT2VAL[(int)cell->clone_base] == 4 || NT2VAL[(int)cell->genome_base] == 4) cell->score += score_n_match;
	else if (cell->genome_base == cell->clone_base) cell->score += score_match;
	else cell->score += score_mismatch;
#ifdef SHOW_PARENTSEARCH
printf("total parents considered: %d\n",num_parents);
#endif
	best_list->insert(cell);
}

static Cell *thread_cells()
{
	Cell *scan = *(best_list->begin());
	unsigned int parent_gap_right = scan->gap_left;
	scan->gap_left = scan->gap_right;
	scan->gap_right = 0; /* unknown errors to right of last child */
	scan->child = 0;
	while(scan->parent != 0) {
		unsigned int temp = scan->parent->gap_left;
		scan->parent->gap_left = scan->parent->gap_right;
		scan->parent->gap_right = parent_gap_right;
		parent_gap_right = temp;
		scan->parent->child = scan;
		scan = scan->parent;
	}
	scan->gap_left = 0; /* unknown errors to left of first parent */
	return scan;
}

static Cell *thread_cells_clean()
{
	Cell *scan = *(best_list->begin());
	unsigned int parent_gap_right = scan->gap_left;
	scan->gap_left = scan->gap_right;
	scan->gap_right = 0; /* unknown errors to right of last child */
	scan->child = 0;
	scan->near_neighbour = 0; /* sanitize */
	while(scan->parent != 0) {
		unsigned int temp = scan->parent->gap_left;
		scan->parent->gap_left = scan->parent->gap_right;
		scan->parent->gap_right = parent_gap_right;
		parent_gap_right = temp;
		scan->parent->child = scan;
		scan = scan->parent;
		scan->near_neighbour = 0; /* sanitize */
	}
	scan->gap_left = 0; /* unknown errors to left of first parent */
	return scan;
}

static void destroy_grid_cells()
{
	set<Cell *>::const_iterator cis;
	for (cis = grid->begin();cis != grid->end(); cis++) {
		delete *cis;
	}
}

static void destroy_non_alignment_cells()
{
	set<Cell *>::const_iterator cis;
	for (cis = grid->begin();cis != grid->end(); cis++) {
		if ((*cis)->child == &no_child) delete *cis;
	}
}

struct Cell *clone_cell_list(Cell *source_start)
{
	struct Cell *target_start = 0;
	struct Cell *target_scan = 0;
	while (source_start != 0) {
		struct Cell *next_cell = new Cell(*source_start);
		next_cell->near_neighbour = 0; /* sanitize clone */
		if (target_scan == 0) {
			target_start = next_cell;
			next_cell->parent = 0;
			next_cell->child = 0;
		} else {
			target_scan->child = next_cell;
			next_cell->parent = target_scan;
			next_cell->child = 0;
		}
		target_scan = next_cell;
		source_start = source_start->child;
	}
	return target_start;
}

int createSeqLocusAlignment(Cell **alignment_start,
		double *alignment_score,
		dnaSeq *querySequence,
		Locus *locus,
		diagSeg *defPosList,
		int negative_strand_rc,
		int *misorientation,
                bool cutoffCare)
{
try {
	*alignment_start = 0;
	if (grid != 0) delete grid;
	grid = new set<Cell *, ColumnMajor>;
	if (best_list != 0) delete best_list;
	best_list = new multiset<Cell *, ScoreOrder>;
	while (defPosList != 0) {
#undef SHOW_DIAGONALS
#ifdef SHOW_DIAGONALS
printf("diag: %u,%u -> %u,%u\n", defPosList->qStart, defPosList->tStart, defPosList->qEnd, defPosList->tEnd);
#endif
		gridAddDiagonal(defPosList->qStart,defPosList->tStart,defPosList->qEnd,
				querySequence, locus);
		gridAddEndpointBackward(defPosList->qStart,defPosList->tStart,
				querySequence, locus);
		gridAddEndpointForward(defPosList->qEnd,defPosList->tEnd,
				querySequence, locus);
		defPosList = defPosList->next;
	}
        if (grid->empty()) {
            delete best_list;
            best_list = 0;
            return GRID_EMPTY;
        }
	gridSetNearNeighbour();
	//we now have the grid
        set<Cell *>::const_iterator cis;
	unsigned int total_grid_size = 0;
	for(cis=grid->begin();cis!=grid->end() && grid != 0;cis++){
	  ++total_grid_size;
	}
        if ((cutoffCare) && (total_grid_size > init_cell_number_cutoff)) {
             destroy_grid_cells();
             delete grid;
             grid = 0;
             delete best_list;
             best_list = 0;
             return GRID_OVERLOADED;
        }
      	 
        *misorientation = SPA_CLONE_ORIENTATION_UNKNOWN; 
	double no_parent_score = querySequence->size * log(0.25); /* everything unobserved */
	switch (*misorientation) {
	default:
		fprintf(stderr, "Error - illegal value passed for misorientation argument into createSeqLocusAlignment()\n");
                destroy_grid_cells();
		delete grid;
		delete best_list;
		return SPA_ERROR;
	case SPA_CLONE_ORIENTATION_CORRECT:
		/* perform threading with correct orientation */
		for (cis = grid->begin();cis != grid->end(); cis++) {
			cell_compute_score(*cis,querySequence,locus,negative_strand_rc != 0,no_parent_score);
		}
		*alignment_score = (*best_list->begin())->score;
		*alignment_start = thread_cells_clean();
		destroy_non_alignment_cells();
		break;
	case SPA_CLONE_ORIENTATION_MISORIENTED:
		/* perform threading assuming misorientation */
		for (cis = grid->begin();cis != grid->end(); cis++) {
			cell_compute_score(*cis,querySequence,locus,negative_strand_rc == 0,no_parent_score);
		}
		*alignment_score = (*best_list->begin())->score;
		*alignment_start = thread_cells_clean();
		destroy_non_alignment_cells();
		break;
	case SPA_CLONE_ORIENTATION_UNKNOWN:
		/* first perform threading to test misorientation */
		for (cis = grid->begin();cis != grid->end(); cis++) {
			cell_compute_score(*cis,querySequence,locus,negative_strand_rc == 0,no_parent_score);
		}
		Cell *misoriented_alignment_start = thread_cells();
		double misoriented_score = (*best_list->begin())->score;
		/* make copy (clone) of alignment so grid can be reused */
		Cell *alignment_clone_start = clone_cell_list(misoriented_alignment_start);
		/* reset children pointers in grid for second pass */
		while (misoriented_alignment_start != 0) {
			struct Cell *ma_child = misoriented_alignment_start->child;
			misoriented_alignment_start->child = &no_child;
			misoriented_alignment_start = ma_child;
		}
		misoriented_alignment_start = alignment_clone_start;
		/* reset best_list for second pass */
		best_list->clear();
		/* perform threading with correct orientation */
		for (cis = grid->begin();cis != grid->end(); cis++) {
			cell_compute_score(*cis,querySequence,locus,negative_strand_rc != 0,no_parent_score);
		}
		*alignment_score = (*best_list->begin())->score;
		if (*alignment_score >= (misoriented_score+min_diff_misorientation)) {
			/* junk misoriented clone */
			destroyAlignment(&misoriented_alignment_start);
			*alignment_start = thread_cells_clean();
			destroy_non_alignment_cells();
			*misorientation = SPA_CLONE_ORIENTATION_CORRECT;
		} else {
			/* return misoriented alignment */
			*alignment_score = misoriented_score;
			*alignment_start = misoriented_alignment_start;
			*misorientation = SPA_CLONE_ORIENTATION_MISORIENTED;
		}
		break;
	}
	delete grid;
	grid = 0;
	delete best_list;
	best_list = 0;
	return SPA_SUCCESS;
}
catch (bad_alloc) {
	if (grid != 0) {
		destroy_grid_cells();
		delete grid;
	}
	grid = 0;
	if (best_list != 0) {
		delete best_list;
	}
	best_list = 0;
	return SPA_OUTOFMEMORY_ERROR;
}
}


void destroyAlignment(Cell **alignment_start)
{
        unsigned int number = 0;
	while (*alignment_start != 0) {
		Cell *to_be_deleted = *alignment_start;
		*alignment_start = (*alignment_start)->child;
		delete to_be_deleted;
                number++;
	}
}

struct OffsetRange
{
	unsigned int begin;
	unsigned int end;
	OffsetRange(unsigned int a_begin, unsigned int a_end) :
			 begin(a_begin), end(a_end) {}
};

struct AlignedRange
{
  unsigned int clone_begin;
  unsigned int clone_end;
  unsigned int genome_begin;
  unsigned int genome_end;
  unsigned int before_intron;
  AlignedRange(unsigned int a_clone_begin, unsigned int a_clone_end,
               unsigned int a_genome_begin, unsigned int a_genome_end, unsigned int a_before_intron) :
    clone_begin(a_clone_begin), clone_end(a_clone_end),
    genome_begin(a_genome_begin), genome_end(a_genome_end) , before_intron(a_before_intron) {}
};

struct IntPair 
{
	unsigned int begin;
	unsigned int end;
	
	IntPair(unsigned int b, unsigned int e) :
		begin(b), end(e) {}
};

bool retile_gap(list<IntPair> *pair_list, unsigned int beg, unsigned int end) {
	if (! pair_list)
		return true;
	list<IntPair>::const_iterator iter;
	for (iter = pair_list->begin(); iter != pair_list->end(); iter++) {
		if (iter->begin == beg && iter->end == end)
			return false;
	}
	return true;
}
                  
int createGenomeGapList(list<OffsetRange> *gap_list, Cell *alignment_start, unsigned int seq_size)
{
	if (!gap_list) return SPA_ERROR;
	gap_list->clear();

	if (!alignment_start) {
		/* no alignment */
		if (seq_size >= retile_genomic_gap_lower_limit && seq_size <= retile_genomic_gap_upper_limit) {
			/* whole query is gap */
			gap_list->push_back(OffsetRange(0,seq_size-1));
		}	
		return SPA_SUCCESS; 
	}
	if (alignment_start->clone_pos >= retile_genomic_gap_lower_limit) {
		/* gap at start */
		gap_list->push_back(OffsetRange(0,alignment_start->clone_pos - 1));
	}
	while (alignment_start->child) {
		unsigned int gap_size = alignment_start->child->clone_pos - alignment_start->clone_pos - 1;
		if (gap_size >= retile_genomic_gap_lower_limit && gap_size <= retile_genomic_gap_upper_limit) {
			gap_list->push_back(OffsetRange(alignment_start->clone_pos + 1,
							alignment_start->child->clone_pos - 1));
		}
		alignment_start = alignment_start->child;
	}
	if (alignment_start->clone_pos + 1 + retile_genomic_gap_lower_limit <= seq_size &&
			alignment_start->clone_pos + 1 + retile_genomic_gap_upper_limit >= seq_size) {
		/* gap at end */
		gap_list->push_back(OffsetRange(alignment_start->clone_pos + 1, seq_size - 1));
	}
	return SPA_SUCCESS;
}

int createExonList(list<AlignedRange> *exon_list, list<AlignedRange> *small_gaps, Cell *alignment_start, unsigned int seq_size)
{
	if (!exon_list) return SPA_ERROR;
	exon_list->clear();

        if(!small_gaps) return SPA_ERROR;
        small_gaps->clear();

	if (!alignment_start) {
		/* no alignment, no exons */
		return SPA_SUCCESS; 
	}
	unsigned int genome_start = alignment_start->genome_pos;
	unsigned int genome_end = genome_start;
	unsigned int clone_start = alignment_start->clone_pos;
	unsigned int clone_end = clone_start; 
        unsigned int before_intron = 0;

	while (alignment_start->child) {
		unsigned int child_genome_pos = alignment_start->child->genome_pos;
		unsigned int child_clone_pos = alignment_start->child->clone_pos;
                unsigned int leftgap = alignment_start->gap_right;
                unsigned int rightgap = alignment_start->child->gap_left;
		if (child_genome_pos >= genome_end + retile_exon_extension + 1 ||
				child_clone_pos >= clone_end + retile_exon_extension + 1) {
			/* start new exon */
                        if(child_genome_pos-genome_end-leftgap-rightgap > 0){
                           before_intron = 1;
                        }
                        else{
                           before_intron = 0;
                        }
		        exon_list->push_back(AlignedRange(clone_start, clone_end, genome_start, genome_end,before_intron));	
			genome_start = child_genome_pos;
			clone_start = child_clone_pos;
		}
                else if ((child_clone_pos > clone_end + 1) && (child_clone_pos <= clone_end + retile_exon_extension)){
                  small_gaps->push_back(AlignedRange(clone_end, child_clone_pos,genome_end,child_genome_pos,before_intron));
                }
		genome_end = child_genome_pos;
		clone_end = child_clone_pos;
		alignment_start = alignment_start->child;
	}
	/* insert last exon */
        before_intron = 0;
        exon_list->push_back(AlignedRange(clone_start, clone_end, genome_start, genome_end,before_intron));	
	return SPA_SUCCESS;
}

int add_smallgap_fuzz(list<AlignedRange> *small_gaps,diagSeg **defPosList,int qSize,bool *performAl) {
  if (!small_gaps) return SPA_ERROR;
  list<AlignedRange>::const_iterator ei;
  for (ei=small_gaps->begin(); ei != small_gaps->end(); ei++) {
    *performAl = true;
    //now go and actually add the fuzz
    //this is done by adding the boundary points as diagonals of length 1 to the DefPosList
    //a fuzz will then automatically added to them when the grid is built
    diagSeg *thisdiag;
    thisdiag = new diagSeg;
    thisdiag->qStart = ei->clone_begin;
    thisdiag->qEnd = ei->clone_begin;
    thisdiag->tStart = ei->genome_begin;
    thisdiag->tEnd = ei->genome_begin;
    thisdiag->diagonal = thisdiag->tStart +qSize-1 -thisdiag->qStart;
    thisdiag->next = 0;
    insertDefPos(&thisdiag,defPosList);
                                                                                                                                           
    thisdiag = new diagSeg;
    thisdiag->qStart = ei->clone_end;
    thisdiag->qEnd = ei->clone_end;
    thisdiag->tStart = ei->genome_end;
    thisdiag->tEnd = ei->genome_end;
    thisdiag->diagonal = thisdiag->tStart +qSize-1 -thisdiag->qStart;
    thisdiag->next = 0;
    insertDefPos(&thisdiag,defPosList);
  }
  return 0;
}

int add_fuzz_noncan_sb(list<AlignedRange> *exon_list, Locus *locus,int negative_strand_rc,int misorientation,diagSeg **defPosList,int qSize,bool *performAl) {
     if (!exon_list) return SPA_ERROR;
     const unsigned int offset = locus->get_startOffset();
     const char *locus_dna = locus->get_dna();
     const AlignedRange *next_exon = 0;
     list<AlignedRange>::const_iterator ei;
     for (ei=exon_list->begin(); ei != exon_list->end(); ei++) {
       //check if genome jump is intron
       if(ei->before_intron){
         //check this splice boundary
         ei++;
         next_exon = &*ei;
         ei--;
         unsigned int genomepos_lb = (ei->genome_end)-offset;
         unsigned int genomepos_rb = (next_exon->genome_begin)-offset;
         char baseone = locus_dna[genomepos_lb+1];
         char basetwo = locus_dna[genomepos_lb+2];
         char basethree = locus_dna[genomepos_rb-2];
         char basefour = locus_dna[genomepos_rb-1];
         int dothisone = 1;
         //check for canonical splice boundary forward
         if((misorientation == SPA_CLONE_ORIENTATION_CORRECT) == (negative_strand_rc == 0)){
           if((baseone == 'g' || baseone == 'G') && (basetwo == 't' || basetwo == 'T') &&
              (basethree == 'a' || basethree == 'A') && (basefour == 'g' || basefour == 'G')){
             dothisone = 0;
           }
         }
         //check for canonical boundary backward
         else{
           if((baseone == 'c' || baseone == 'C') && (basetwo == 't' || basetwo == 'T') &&
              (basethree == 'a' || basethree == 'A') && (basefour == 'c' || basefour == 'C')){
             dothisone = 0;
           }
         }
         if(dothisone){
           *performAl = true;
           //now go and actually add the fuzz
           //this is done by adding the boundary points as diagonals of length 1 to the DefPosList
           //a fuzz will then automatically added to them when the grid is built
           diagSeg *thisdiag;
           thisdiag = new diagSeg;
           thisdiag->qStart = ei->clone_end;
           thisdiag->qEnd = ei->clone_end;
           thisdiag->tStart = ei->genome_end;
           thisdiag->tEnd = ei->genome_end;
           thisdiag->diagonal = thisdiag->tStart +qSize-1 -thisdiag->qStart;
           thisdiag->next = 0;
           insertDefPos(&thisdiag,defPosList);
                                                                                                                                           
           thisdiag = new diagSeg;
           thisdiag->qStart = next_exon->clone_begin;
           thisdiag->qEnd = next_exon->clone_begin;
           thisdiag->tStart = next_exon->genome_begin;
           thisdiag->tEnd = next_exon->genome_begin;
           thisdiag->diagonal = thisdiag->tStart +qSize-1 -thisdiag->qStart;
           thisdiag->next = 0;
           insertDefPos(&thisdiag,defPosList);
         }
       }
     }
                                                                                                                                           
     return 0;
}



static const char * const SUBSEQUENCE_NAME_STRING = "retiling_subsequence";

int  process_extension(Locus *locus, diagSeg *defPosList, diagSeg **subDefPosList, dnaSeq *querySequence, int negative_strand_rc, 
                       int *misorientation, unsigned int beg, unsigned int end, list<AlignedRange> exon_list, 
                       unsigned int a_cloneExpand) {

  try {
     int retval;
     int gap_size = end - beg + 1;
     bool threeprimetail = (*misorientation == SPA_CLONE_ORIENTATION_CORRECT) == (negative_strand_rc == 0);
     if (threeprimetail && end == (unsigned int)(querySequence->size - 1) ||
         !threeprimetail && beg == 0) {
         /* filter poly a tails */
         unsigned int count = 0;
         unsigned int pos;
         if (threeprimetail) {
             for (pos=beg; pos <= end; pos++){
                  char base = querySequence->dna[pos];
                  if (base == 'a' || base == 'A') count++;
             } 
         } else {
             for (pos=beg; pos <= end; pos++){
                  char base = querySequence->dna[pos];
                  if (base == 't' || base == 'T') count++;
             }
         }
         if (count * 100 > retile_poly_a_percentage * gap_size) {
             *subDefPosList = NULL; 
             return SPA_SUCCESS;
         }
     }
     
     const AlignedRange *prev_exon = 0;
     const AlignedRange *next_exon = 0;
     list<AlignedRange>::const_iterator ei;
     for (ei=exon_list.begin(); ei != exon_list.end(); ei++) {
          if (ei->clone_end < beg) {
              prev_exon = &*ei;
          }
          if (ei->clone_begin > end) {
              next_exon = &*ei;
              break;
          }
     }    

     unsigned int subsequence_start;
     unsigned int subsequence_end;
     unsigned int sublocus_start;
     unsigned int sublocus_end;
     unsigned int tmp;

     if (prev_exon == 0) {
         locus->expand_left();
         sublocus_start = locus->get_startOffset();
         subsequence_start = 0;
     } else {
         tmp = prev_exon->clone_end - prev_exon->clone_begin;
         if (tmp >= a_cloneExpand) {
             subsequence_start = prev_exon->clone_end - a_cloneExpand;
             sublocus_start = prev_exon->genome_end - a_cloneExpand;
         }
         else {
             subsequence_start = prev_exon->clone_begin;
             sublocus_start = prev_exon->genome_begin;
         }
     }
     if (next_exon == 0) {
         locus->expand_right();
         sublocus_end = locus->get_endOffset();
         subsequence_end = querySequence->size - 1;
     } else {
         tmp = next_exon->clone_end - next_exon->clone_begin;
         if (tmp >= a_cloneExpand) {
             subsequence_end = next_exon->clone_begin + a_cloneExpand;
             sublocus_end = next_exon->genome_begin + a_cloneExpand;
         }
         else {
             subsequence_end = next_exon->clone_end;
             sublocus_end = next_exon->genome_end;
        }
     } 


     /* extract subsequence */
     dnaSeq *querySubSequence = new dnaSeq;
     querySubSequence->next = 0;
     querySubSequence->name = (char *)SUBSEQUENCE_NAME_STRING;
     querySubSequence->size = subsequence_end - subsequence_start + 1;
     querySubSequence->dna = new char[querySubSequence->size + 1];
     strncpy(querySubSequence->dna,querySequence->dna + subsequence_start,querySubSequence->size);
     querySubSequence->dna[querySubSequence->size] = '\0';

     int tilesize = locus->get_tileSize(); 
     int tileoverlay = locus->get_tileOverlay();
     unsigned int nbDefinedP;

     Locus *subLocus; 

     do {
         subLocus = new Locus(*locus,sublocus_start,sublocus_end, tilesize, tileoverlay);
         if (subLocus->get_constructorError() != LOCUS_SUCCESS) {
             fprintf(stderr, "Error during construction of retiled sublocus: %d\n", subLocus->get_constructorError());
             return subLocus->get_constructorError();
         }
     
         /* align subsequence to sublocus */
         retval = createDefPosList(subDefPosList, querySubSequence, subLocus);
         if (retval != SPA_SUCCESS) {
             if (retval != DEFPOS_EMPTY) {
                 fprintf(stderr, "Warning : getDefPosList() returned error code %d during retiling\n", retval);
             }
             delete[] querySubSequence->dna;
             delete querySubSequence;
             return SPA_SUCCESS;
         } 
         nbDefinedP = get_size(*subDefPosList, tilesize);
         if (nbDefinedP > extension_cell_number_cutoff) {
             delete subLocus;
             destroyDefPosList(subDefPosList);
             tilesize += DEFAULT_STEP_TILESIZE;
         }
         else {
             if (nbDefinedP == 0) {
                 delete subLocus;
                 tilesize -= DEFAULT_STEP_TILESIZE;
             }
         }
      } while(nbDefinedP > extension_cell_number_cutoff);
 
      normalizeDefPos(subDefPosList, querySubSequence->size, subsequence_start, subsequence_end);
      delete[] querySubSequence->dna;
      delete querySubSequence;
      delete subLocus;
      return SPA_SUCCESS;
  } catch (bad_alloc) {
    return SPA_OUTOFMEMORY_ERROR;
  }         
}         


int createAlignment(Cell **alignment_start,
		double *alignment_score,
		dnaSeq *querySequence,
		Locus *locus,
		diagSeg *defPosList,
		int negative_strand_rc,
		int *misorientation,
                unsigned int a_cloneExpand)
{
try {
	int retval;
	if (!locus || !querySequence || !misorientation) {
		fprintf(stderr,"Error: illegal null pointer passed in to createAlignment.\n");
		return SPA_ERROR;
	}
	if ((int)(locus->get_endOffset())<0) { /* rely on twos complement overflow to negative */
		fprintf(stderr,"Error: locus is too long for current spa implementation.\n");
		return SPA_ERROR;
	}
	/* first pass alignment (before any needed retiling) */
	retval = createSeqLocusAlignment(alignment_start, alignment_score,
			querySequence, locus, defPosList,
			negative_strand_rc, misorientation, true);
        if (retval == GRID_OVERLOADED) {
            destroyDefPosList(&defPosList);
            if (locus->get_tileSize() >= DEFAULT_MAX_TILESIZE)
                return INCREASE_TILESIZE;
        }

	if (retval != SPA_SUCCESS) {
            *alignment_score = -DBL_MAX;
             destroyDefPosList(&defPosList);
            return retval;
        }
        
#define USE_DYNAMIC_TILE_RESIZING
#ifdef USE_DYNAMIC_TILE_RESIZING

       if (locus->get_tileSize()  <= MINIMUM_RETILE_TILESIZE) {
           destroyDefPosList(&defPosList);
           return SPA_SUCCESS;
       }
       retile_tilesize = locus->get_tileSize() - DEFAULT_STEP_TILESIZE;

       int numberOfTime = 0;
       /* make list of genome gaps */
       list<OffsetRange> retile_list;
       unsigned int qSize = querySequence->size;
 
       retval = createGenomeGapList(&retile_list,*alignment_start, qSize);
       if (retval != SPA_SUCCESS) {
           destroyDefPosList(&defPosList);
           return retval;
       }

       bool startEnd = false;     
       list<IntPair> gapsNotToRetile;      
 
       list<AlignedRange> exon_list;
       list<AlignedRange> small_gaps;
       retval = createExonList(&exon_list,&small_gaps,*alignment_start,querySequence->size); 
       if (retval != SPA_SUCCESS) {
           destroyDefPosList(&defPosList);
           return retval; 
       }

       unsigned int beg_start = 0;
       unsigned int beg_end = 0;
       unsigned int end_start = 0;
       unsigned int end_end = 0;

       if (retile_list.size() == 1) {
           beg_start = retile_list.begin()->begin;
           beg_end = retile_list.begin()->end;
           end_start = beg_start;
           end_end = beg_end;
       }
       else if (retile_list.size() > 1) {
           beg_start = retile_list.begin()->begin;
           beg_end = retile_list.begin()->end;
           end_start = retile_list.rbegin()->begin;
           end_end = retile_list.rbegin()->end; 
       }

       //Check for insertion at the beginning of the clone
       if ((beg_start == 0) && (beg_end != 0)) {
            diagSeg *subDefPosList;
            retval = process_extension(locus, defPosList, &subDefPosList, querySequence, negative_strand_rc, misorientation, beg_start, beg_end, exon_list, a_cloneExpand);
            if (retval != SPA_SUCCESS) {
                destroyDefPosList(&defPosList);
                return retval;
            }

            if (subDefPosList != NULL) { 
                insertDefPos(&subDefPosList, &defPosList);
                startEnd = true;
            }
       }
       // Check for insertion at the end of the clone
       if ((end_start != 0) && (end_end == (qSize - 1))) { 
            diagSeg *subDefPosList;
            retval = process_extension(locus, defPosList, &subDefPosList, querySequence, negative_strand_rc, misorientation, end_start, end_end, exon_list, a_cloneExpand);
            if (retval != SPA_SUCCESS){
                destroyDefPosList(&defPosList);
                return retval;
            }

            if (subDefPosList != NULL) {
                insertDefPos(&subDefPosList, &defPosList);
                startEnd = true;
            }
       }
       
       if (startEnd) {
           locus->set_size();
           destroyAlignment(alignment_start);
           retval = createSeqLocusAlignment(alignment_start, alignment_score,
                                        querySequence, locus, defPosList,
                                        negative_strand_rc, misorientation, false);
           if (retval != SPA_SUCCESS || alignment_start == 0) {
               destroyDefPosList(&defPosList);
               return retval;
           }
       }

       bool performAlignment = false;
       while (retile_tilesize >= MINIMUM_RETILE_TILESIZE) {
           numberOfTime++;
           list<OffsetRange> retile_list;
	   retval = createGenomeGapList(&retile_list,*alignment_start,querySequence->size);
           if (retval != SPA_SUCCESS) {
               destroyDefPosList(&defPosList);
               return retval;
           }
           
           diagSeg *subDefPosList;
           Locus *subLocus;
	   /* attempt repair of gaps through retiling */
           int retile_number = 0;
           unsigned int gap_size = 0;
           list<OffsetRange>::const_iterator ri;
         
           if (! exon_list.empty())
             exon_list.clear();
           if( ! small_gaps.empty())
             small_gaps.clear();

           retval = createExonList(&exon_list,&small_gaps,*alignment_start,querySequence->size);
            if (retval != SPA_SUCCESS) {
                destroyDefPosList(&defPosList);
                return retval;
            }
            //add fuzz to noncanonical splice boundaries
            add_fuzz_noncan_sb(&exon_list, locus,negative_strand_rc,*misorientation,&defPosList,querySequence->size,&performAlignment);
            //add fuzz to begin and end of all small gaps
            add_smallgap_fuzz(&small_gaps,&defPosList,querySequence->size,&performAlignment);

	   for (ri=retile_list.begin(); ri != retile_list.end(); ri++) {
		gap_size = ri->end - ri->begin + 1;
		if (! retile_gap(&gapsNotToRetile, ri->begin, ri->end)) {
			continue;
		}
		bool threeprimetail = (*misorientation == SPA_CLONE_ORIENTATION_CORRECT) == (negative_strand_rc == 0);
		if (threeprimetail && ri->end == (unsigned int)(querySequence->size - 1) ||
				!threeprimetail && ri->begin == 0) {
			/* filter poly a tails */
			unsigned int count = 0;
			unsigned int pos;
			if (threeprimetail) {
				for (pos=ri->begin; pos <= ri->end; pos++){
					char base = querySequence->dna[pos];
					if (base == 'a' || base == 'A') count++;
				}
			} else {
				for (pos=ri->begin; pos <= ri->end; pos++){
					char base = querySequence->dna[pos];
					if (base == 't' || base == 'T') count++;
				}
			}
			if (count * 100 > retile_poly_a_percentage * gap_size) continue;
		}

		/* create sublocus */
                const AlignedRange *prev_exon = 0;
                const AlignedRange *next_exon = 0;
                list<AlignedRange>::const_iterator ei;
                for (ei=exon_list.begin(); ei != exon_list.end(); ei++) {
                        if (ei->clone_end < ri->begin) {
                                prev_exon = &*ei;
                        }
                        if (ei->clone_begin > ri->end) {
                            next_exon = &*ei;
                            break;
                        }
                }	
		unsigned int subsequence_start;
		unsigned int subsequence_end;
		unsigned int sublocus_start;
		unsigned int sublocus_end;
                unsigned int tmp;
		if (prev_exon == 0) {
                    sublocus_start = locus->get_startOffset();
		    subsequence_start = 0;
		} else {
                    tmp = prev_exon->clone_end - prev_exon->clone_begin;
                    if (tmp >= a_cloneExpand) {
                        subsequence_start = prev_exon->clone_end - a_cloneExpand;
                        sublocus_start = prev_exon->genome_end - a_cloneExpand;
                    }
                    else {
                        subsequence_start = prev_exon->clone_begin;
                        sublocus_start = prev_exon->genome_begin;
                    }
                }
		if (next_exon == 0) {
		    sublocus_end = locus->get_endOffset();
		    subsequence_end = querySequence->size - 1;
		} else {
                    tmp = next_exon->clone_end - next_exon->clone_begin;
                    if (tmp >= a_cloneExpand) {
                        subsequence_end = next_exon->clone_begin + a_cloneExpand;
                        sublocus_end = next_exon->genome_begin + a_cloneExpand;
                    }
                    else {
                        subsequence_end = next_exon->clone_end;
                        sublocus_end = next_exon->genome_end;
                    }
		}

                if ((retile_tilesize == MINIMUM_RETILE_TILESIZE) && 
                    ((subsequence_start == 0) || (subsequence_end == (unsigned int)(querySequence->size - 1))))
                      continue;
                      
                retile_number++;
 
		subLocus = new Locus(*locus,sublocus_start,sublocus_end,retile_tilesize,retile_tileoverlay);
		if (subLocus->get_constructorError() != LOCUS_SUCCESS) {
                        destroyDefPosList(&defPosList);
			fprintf(stderr, "Error during construction of retiled sublocus: %d\n", subLocus->get_constructorError());
			return subLocus->get_constructorError();
		}
		/* extract subsequence */
		dnaSeq *querySubSequence = new dnaSeq;
		querySubSequence->next = 0;
		querySubSequence->name = (char *)SUBSEQUENCE_NAME_STRING;
		querySubSequence->size = subsequence_end - subsequence_start + 1;
		querySubSequence->dna = new char[querySubSequence->size + 1];
		strncpy(querySubSequence->dna,querySequence->dna + subsequence_start,querySubSequence->size);
		querySubSequence->dna[querySubSequence->size] = '\0';

#if 0 
printf("subquery: %u - %u\n",subsequence_start,subsequence_end);
printf("retiling sublocus: %u - %u\n",sublocus_start,sublocus_end);
#endif
               
		/* align subsequence to sublocus */
		retval = createDefPosList(&subDefPosList, querySubSequence, subLocus);
		if (retval != SPA_SUCCESS) {
                        if (retval != DEFPOS_EMPTY) {
			    fprintf(stderr, "Warning : getDefPosList() returned error code %d during retiling\n", retval);
                        }
			delete[] querySubSequence->dna;
			delete querySubSequence;
                        delete subLocus;
                        destroyDefPosList(&subDefPosList);
                        continue;
		}


#undef SHOW_RETURNED_DEFPOS
#ifdef SHOW_RETURNED_DEFPOS
int tcount=0;
int qcount=0;
struct diagSeg *sc;
for (sc = subDefPosList; sc; sc = sc->next){
printf("seg: (%u %u) - (%u %u)\n",sc->qStart,sc->qEnd,sc->tStart,sc->tEnd);
unsigned t;
for (t=sc->tStart; t<= sc->tEnd; t++)
printf("%c",getLocusBase(&subLocus,t));
printf("\n");
tcount += sc->tEnd - sc->tStart;tcount++;
qcount += sc->qEnd - sc->qStart;qcount++;
}
printf("totals: %d - %d\n",qcount,tcount);
#endif

                if (get_size(subDefPosList, retile_tilesize) > inside_retiling_cell_number_cutoff) {
		    gapsNotToRetile.push_back(IntPair(ri->begin, ri->end));
                    delete[] querySubSequence->dna;
                    delete querySubSequence;
                    delete subLocus;
                    destroyDefPosList(&subDefPosList);
                    continue; 
                }
                
                performAlignment = true;
                normalizeDefPos(&subDefPosList, querySubSequence->size, subsequence_start, subsequence_end);
	       	insertDefPos(&subDefPosList, &defPosList);
		delete[] querySubSequence->dna;
		delete querySubSequence;
                delete subLocus; 
	}
  
        if (performAlignment) {
            destroyAlignment(alignment_start);
            retval = createSeqLocusAlignment(alignment_start, alignment_score,
                                querySequence, locus, defPosList,
                                negative_strand_rc, misorientation, false);

            if (retval != SPA_SUCCESS || alignment_start == 0) {
                destroyDefPosList(&defPosList);
                return retval;
            }
            performAlignment = false;
        }
        retile_tilesize = retile_tilesize - DEFAULT_STEP_TILESIZE;
        if (retile_list.empty())
            break;
      } 
#endif
        destroyDefPosList(&defPosList);
	return SPA_SUCCESS;
} catch (bad_alloc) {
	return SPA_OUTOFMEMORY_ERROR;
}
}
