#######################################################
# Estimate deletion parameters                        #
#######################################################

package Deletion;

use strict;
use warnings;

sub new {
    my $that = shift;
    my $class = ref($that) || $that;

    my $iData = shift;

    unless (defined($iData)) {
        die "Insertion Data undefined\n";
    }

    my $sumFreq = 0;
    my $sumFreq4 = 0; # frequency sum for delLength > 3
    my $sumLen4 = 0;  # 
    my $k;
    foreach $k (keys %{$iData}) { 
		if ($k < 26) {
               		$sumFreq += $iData->{$k};
               		if ($k > 3) {
                   		$sumFreq4 += $iData->{$k};
                   		$sumLen4 += $k * $iData->{$k};
               		}
		}
    }
    if ($sumFreq4 == 0) {
	die "No Deletion greater than 3 or not enough sequences for estimation\n";
    }
    if ($sumFreq == 0) {
	die "No Deletion or not enough sequences for estimation\n";
    }
    if ($iData->{0} <= 0) {
	die "Bad number of deletion of length 0\n";
    }
    my $mean = $sumLen4/$sumFreq4;
    my $beta0 = log($iData->{0}/$sumFreq);
    my $beta1 = log($iData->{1}/$sumFreq) - $beta0;
    my $beta2 = log($iData->{2}/$sumFreq) - $beta1 - $beta0;
    my $beta3 = log($iData->{3}/$sumFreq) - $beta2 - $beta1 - $beta0;

    my $self = {
       score_genome_jump_beta0	=>	$beta0,
       score_genome_jump_beta1	=>	$beta1,
       score_genome_jump_beta2	=>	$beta2,
       score_genome_jump_beta3	=>	$beta3,
       score_genome_jump_alpha	=>	-log(($mean-3)/($mean-4))
    };
  
    bless($self, $class);
    return $self;
}

sub new_unbiased {
        my $that = shift;
        my $class = ref($that) || $that;
                                                                                                                                                         
        my $epsilon = shift;
        my $mean4 = shift;
	my $mean = $mean4 - 3;
                                                                                                                                                         
        unless (($epsilon >= 0) && ($epsilon < 1)) {
                die "Insertion::new_unbiased -> Bad epsilon number $epsilon\n";
        }
        unless($mean > 4) {
                die "Insertion::new_unbiased -> Bad mean length $mean\n";
        }
                                                                                                                                                         
        my $beta0 = log(1.0-$epsilon);
        my $beta1 = log($epsilon/$mean) - $beta0;
        my $beta2 = log($epsilon*($mean-1)/($mean*$mean)) - $beta1 - $beta0;
        my $beta3 = log($epsilon*($mean-1)*($mean-1)/($mean*$mean*$mean)) - $beta2 - $beta1 - $beta0;
                                                                                                                                                         
        my $self = {
                score_genome_jump_beta0   =>      $beta0,
                score_genome_jump_beta1   =>      $beta1,
                score_genome_jump_beta2   =>      $beta2,
                score_genome_jump_beta3   =>      $beta3,
                score_genome_jump_alpha   =>      -log(($mean4-3)/($mean4-4))
        };
                                                                                                                                                         
        bless($self, $class);
        return $self;
}


sub print {
    my $self = shift;

    print "score_genome_jump_beta0 : $self->{score_genome_jump_beta0}\n";
    print "score_genome_jump_beta1 : $self->{score_genome_jump_beta1}\n";
    print "score_genome_jump_beta2 : $self->{score_genome_jump_beta2}\n";
    print "score_genome_jump_beta3 : $self->{score_genome_jump_beta3}\n";
    print "score_genome_jump_alpha : $self->{score_genome_jump_alpha}\n";
}

sub print_data {
    my $self = shift;
    my $out = shift;

    print $out "score_genome_jump_beta0 $self->{score_genome_jump_beta0}\n";
    print $out "score_genome_jump_beta1 $self->{score_genome_jump_beta1}\n";
    print $out "score_genome_jump_beta2 $self->{score_genome_jump_beta2}\n";
    print $out "score_genome_jump_beta3 $self->{score_genome_jump_beta3}\n";
    print $out "score_genome_jump_alpha $self->{score_genome_jump_alpha}\n";
}


1;
