#!/import/bc2/soft/bin/perl5/perl 

#########################################################################################################
# Purpose : set the spa_parameters file									#
#													#
# Usage : extractHighERMappings.pl <inputDir> <outputDir> <input_parameters> <output_parameters>	#
#													#	
#########################################################################################################

use strict;
use warnings;
use Statistics;

if (scalar(@ARGV) != 4) {
    die "Usage : extractHighERMappings.pl <inputDIr> <outputDir> <input_parameters> <output_parameters>\n";
}

unless ( -e $ARGV[0]) {
         die "inputDir not found\n";
}

unless ( -e $ARGV[2]) {
         die "inputDir not found\n";
}

extract_high_error_rate_clones();

sub extract_high_error_rate_clones {
	my $statistics = Statistics->new();
	print "Loading Statistics ... \n";
	$statistics->load($ARGV[0], 10);
	$statistics->set_eRate();
	if (! (-e $ARGV[1])) {
		mkdir($ARGV[1]) || die "Could not make dir $ARGV[1]\n";
	}	
 	$statistics->clean($ARGV[0], $ARGV[1]);
	$statistics->set_parameters($ARGV[2], $ARGV[3]);
}

