## usage: python <scriptname> <melfilename> <psdfilename>
## output: <melfilename>.blk is the list of aligned blocks to be
##         used as input to stubbms.
## output: <melfilename>.mfasta is the concatenation of the mel
##         and psd sequences, to be used as input to stubbms.          

import string
import sys
import commands
import os

def Process (command):
    print "Executing:",command,"\n"
    os.system(command);
    return

## aligned blocks will be at least 10 length
minblklen = 10
## aligned blocks will be at least 70% identical
minpid = 70    

lagandir = os.environ['LAGAN_DIR']
laganscript = lagandir + "/lagan.pl"
extractlaganblocksscript = "helpers/extract_lagan_blks.py"

if len(sys.argv) != 3:
    print "usage: python <scriptname.py> <melfilename> <psdfilename>\n"
    sys.exit()
    
melfile = sys.argv[1]
psdfile = sys.argv[2]

## run lagan
mfafilename = melfile + ".mfa"
command = "%s %s %s -order \"-mt 1 -ms -2 -gs -6 -gc 0\" -mfa -out %s >& __laganlog__" % (laganscript,melfile,psdfile,mfafilename)
Process(command)
Process("rm anchs.final __laganlog__")

## extract blocks
blkfilename = melfile + ".blk"
command = "python %s %s %d %d > %s" %(extractlaganblocksscript,mfafilename,minblklen,minpid, blkfilename)
Process(command)
command = "rm %s" %  (mfafilename)
Process(command)
 
## create mfasta file
mfastafile = melfile + ".mfasta"
command = "cat %s %s > %s" % (melfile,psdfile, mfastafile)
Process(command)

