COMPILER = g++
NEWMATDIR = lib/newmat/
BIN = bin/
LIBS =  -L${NEWMATDIR} -lm -lnewmat
GSLINC = -I${NEWMATDIR}
CCFLAGS = -O3 -D_MARKOV -DMARKOV_ORDER=2 -DCONTEXT_SIZE=5 -D_OPTIMIZE_MOTIFORIENTATION -D_OPTIMIZE_PROTECTED_ACCESS  -D_OPTIMIZE_CAREFULCSP -D_OPTIMIZE_WMINDEX -D_EXIST_SMALL_SEQUENCES -D_CYCLIC_WINDOWS #-D_WTMX_BIAS 
STUBBCCFLAGS = -D_OPTIMIZE_CACHESEQUENCEPROBABILITIES #-D_PRUNE_MOTIFS
STUBBH01CCFLAGS = -D_OPTIMIZE_CACHESEQUENCEPROBABILITIES 

all:  clean stubb stubbh01 stubbh01f stubb_fitprobs stubb_fixedprobs

stubb: Makefile ${NEWMATDIR}/libnewmat.a stubb.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o
	${COMPILER} ${CCFLAGS} ${STUBBCCFLAGS} -o ${BIN}/stubb stubb.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o ${LIBS}

stubbh01: Makefile stubbh01.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o
	${COMPILER} ${CCFLAGS} ${STUBBH01CCFLAGS} -o ${BIN}/stubbh01 stubbh01.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o ${LIBS} 

stubbh01f: Makefile stubbh01f.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o
	${COMPILER} ${CCFLAGS} ${STUBBH01CCFLAGS} -o ${BIN}/stubbh01f stubbh01f.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o ${LIBS} 

stubb_fitprobs: Makefile ${NEWMATDIR}/libnewmat.a stubb_fitprobs.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o
	${COMPILER} ${CCFLAGS} ${STUBBCCFLAGS} -o ${BIN}/stubb_fitprobs stubb_fitprobs.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o ${LIBS}

stubb_fixedprobs: Makefile ${NEWMATDIR}/libnewmat.a stubb_fixedprobs.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o
	${COMPILER} ${CCFLAGS} ${STUBBCCFLAGS} -o ${BIN}/stubb_fixedprobs stubb_fixedprobs.cpp util.o parameters.o parameters_h0.o parameters_h1.o parameters_h01.o sequence.o windowiterator.o wtmx.o fastafile.o ${LIBS}

util.o: Makefile util.cpp util.h parameters.h typedefs.h parameters.o
	${COMPILER} ${CCFLAGS} -c util.cpp

parameters.o: Makefile parameters.cpp parameters.h typedefs.h sequence.o wtmx.o
	${COMPILER} ${CCFLAGS} -c parameters.cpp 

parameters_h0.o: Makefile parameters_h0.cpp parameters.h typedefs.h sequence.o wtmx.o
	${COMPILER} ${CCFLAGS} -c parameters_h0.cpp 

parameters_h1.o: Makefile parameters_h1.cpp parameters.h typedefs.h sequence.o wtmx.o
	${COMPILER} ${CCFLAGS} -c parameters_h1.cpp 

parameters_h01.o: Makefile parameters_h01.cpp parameters.h typedefs.h sequence.o wtmx.o ${NEWMATDIR}/libnewmat.a
	${COMPILER} ${CCFLAGS} ${GSLINC} -c parameters_h01.cpp 

sequence.o: Makefile sequence.cpp sequence.h
	${COMPILER} ${CCFLAGS} -c sequence.cpp

windowiterator.o: Makefile windowiterator.cpp sequence.h
	${COMPILER} ${CCFLAGS} -c windowiterator.cpp

fastafile.o: Makefile fastafile.cpp fastafile.h sequence.h
	${COMPILER} ${CCFLAGS} -c fastafile.cpp

wtmx.o: Makefile wtmx.cpp wtmx.h typedefs.h 
	${COMPILER} ${CCFLAGS} -c wtmx.cpp

clean: 
	rm -rf *.o core *~
