/*****************************************************************
        Copyright by Rockefeller University,
can not be reproduced or distributed without written permission of
copyright holder.  Version of October 2003.

Written by Saurabh Sinha (contact person), Erik van Nimwegen, and 
Eric Siggia.

The program stubb (and its relatives) implement an algorithm for
finding likely cis-regulatory modules, described in the following
paper:
"A Probabilistic Method to Detect Regulatory Modules"
by Saurabh Sinha, Erik van Nimwegen and Eric Siggia. 
Eleventh International Conference on Intelligent Systems for
Molecular Biology, Brisbane, Australia, July 2003, pg 292-301.

The file sample/gap_wtmx that comes with this distribution includes 
a sample set of transcription factor weight matrices (PWM's) that 
were reported in :
"Computational detection of genomic cis-regulatory modules applied
to body patterning in the early Drosophila embryo"
by N. Rajewsky, M. Vergassola, U. Gaul and E. Siggia.
BMC Bioinformatics 3 (30) 2002.
******************************************************************/

#ifndef _STUBBUTIL_H_
#define _STUBBUTIL_H_

#define MIN_WINDOW_LENGTH 20
#define MIN_SPEC_FRACTION 0.5

#include "parameters.h"

struct Options {
  char *output_dir;
  char *bkg_file;
  char *phylogeny_file;
  char *anchors_file;
  char *corr_file;
  int  *corr_list; int corr_list_size;
  float fen_threshold;
  float motif_occurrence_threshold;

  Options() { output_dir = NULL; bkg_file = NULL; phylogeny_file = NULL; anchors_file = NULL; corr_file = NULL; fen_threshold = DEFAULT_FEN_THRESHOLD; motif_occurrence_threshold = DEFAULT_MOTIF_OCCURRENCE_THRESHOLD; corr_list = NULL; corr_list_size = 0; }
  ~Options() { if (corr_list != NULL) delete [] corr_list; }
};

void Warn(const char *str);
FILE *OpenProfile(char *file, char *output_dir = NULL);
FILE *OpenOutput(char *file, char *output_dir = NULL);
FILE *OpenCorrelation(char *file, char *output_dir = NULL);
FILE *OpenDictionary(char *file, char *output_dir = NULL);
FILE *OpenAlignments(char *file, char *output_dir = NULL);
FILE *OpenProbabilities(char *file, char *output_dir = NULL);
void PrintParameters(char *seqfile, char *wmcfile, int windowsize, int shiftsize, struct Options *opt);
struct Options *ReadOptionalArguments(int &argbase, int argc, char **argv);
bool IsValidWindowList(vector<Window *> *wl);
#endif
