#!/usr/bin/perl -w 

## usage: <scriptname> <melfilename> <psdfilename>
## output: <melfilename>.blk is the list of aligned blocks to be
##         used as input to stubbms.
## output: <melfilename>.mfasta is the concatenation of the mel
##         and psd sequences, to be used as input to stubbms.          

use strict;

my $minblklen = 10; ## aligned blocks will be at least 10 length
my $minpid = 70;    ## aligned blocks will be at least 70% identical

my $lagandir = $ENV{'LAGAN_DIR'};
my $laganscript = "$lagandir/lagan.pl";
my $extractlaganblocksscript = "helpers/extract_lagan_blks.py";
if ($#ARGV < 1) {
	print "usage: <scriptname> <melfilename> <psdfilename>\n";
	return;
}

my $melfile = $ARGV[0];
my $psdfile = $ARGV[1];

## run lagan
my $mfafilename = $melfile . ".mfa";
#Process("$laganscript $melfile $psdfile -order \"-mt 1 -ms -2 -gs -6 -gc 0\" -mfa -out $mfafilename >& __laganlog__");
system("$laganscript $melfile $psdfile -order \"-mt 1 -ms -2 -gs -6 -gc 0\" -mfa");
Process("rm anchs.final __laganlog__");

## extract blocks
my $blkfilename = $melfile . ".blk";
Process("python $extractlaganblocksscript $mfafilename $minblklen $minpid > $blkfilename");
Process("rm $mfafilename");
 
## create mfasta file
my $mfastafile = $melfile . ".mfasta";
Process("cat $melfile $psdfile > $mfastafile");

sub Process {
    my $command = shift;
    print "Executing: $command\n";
    # system($command);
}
