/*global $ */

function search_gene_get_remote_dir() {
    /* returns remote results dir from url parsing */
    "use strict";
    var remote_dir, url, url_match;
    remote_dir = null;
    url = document.URL;
    url_match = url.match(/^(http|https):\/\/w*\.?(secure.ismara|mara|ismara|bc2-web78.bc2|ismara.scicore)\.unibas\.ch.*\/(\S+)\/i?s?mara_report/);
    if (url_match) {
        remote_dir = url_match[3];
    }
    return remote_dir;
}

function search_gene_send_data() {
    /* Put entered data into json format and sends it server */
    "use strict";
    /* block ui */
    $.blockUI({overlayCSS: { backgroundColor: '#E4E4E4' }});
    
    var term = $("#search_gene input[name='term']").val().trim();
    var dir = $("#search_gene input[name='dir']").val()

    if (term == "") {
        alert("Please enter gene name!");
        return;
    }
    
    var post_url = "/search_gene/";
    var secure = 0;
    if (document.URL.match(/secure/)) {
        /*post_url = "/secure/search_gene/";*/
        secure = 1;
    }

    $.ajax({
        type: "POST",
        url: post_url, 
        data: {
            "dir": dir,
            "term": term,
            "secure": secure
        },
        beforeSend: function() {$("body").addClass("loading");},
        complete: function(){$("body").removeClass("loading");}
    })
        .done(
            function(x){
                console.log("x:" + x);
                $.unblockUI();
                if (x == "Fail") {
                    alert("Term " + term + " not found.");
                }
                else {
                    var scratch_url = "https://" + window.location.hostname;
                    /*scratch_url += "/ISMARA/scratch/"*/
                    var data = window.location.pathname.split("/");
                    if ($.inArray("averaged_report", data) >= 0) {
                        /* tmp construct is for cases in supp dir where avrg results inside original dirs */
                        var tmp = data.slice(0,data.findIndex(function(x){return x == "averaged_report"}) - 1)
                        if(tmp[tmp.length - 1] == dir){
                            scratch_url += data.slice(0,data.findIndex(function(x){return x == "averaged_report"}) - 2).join("/") + "/";
                        }
                        else {
                            scratch_url += data.slice(0,data.findIndex(function(x){return x == "averaged_report"}) - 1).join("/") + "/";
                        }
                    }
                    else {
                        scratch_url += data.slice(0,data.findIndex(function(x){return x == "ismara_report"}) - 1).join("/") + "/";}
                    console.log(scratch_url + dir + "/" + term + ".html");
                    window.location = scratch_url + dir + "/" + term + ".html";
                }
            });
}

$(function () {
    var remote_dir = search_gene_get_remote_dir();
    if (remote_dir) {
        $("#search_gene").show();
        $("#fov_prom").show() // show fov_prom html link
        //        $("#search_gene_button").button();
    }
    $("#search_gene_button").click(function(){search_gene_send_data();});
    $("#search_gene input[name='term']").keypress(function(event) {
        if (event.which == 13) {
            event.preventDefault();
            search_gene_send_data();
        }
    });
    var path_data = document.location.pathname.split("/")
    var myurl = "../orgnl_link"
    if ($.inArray("averaged_report", path_data) > -1 && $.inArray("pages", path_data) > -1) {
        myurl = "../../orgnl_link"
    }
    $.ajax({
        url: myurl,
        success: function(x)
        {
            var orgnl_url = x; //$.get("../orgnl_link")
            // orgnl_url = orgnl_url.split('"')[1]
            var new_link = "https://" + orgnl_url + "/../" + $("#fov_prom a").attr("href")

            /* bad way to make proper link in averaged motif pages */
            var path_data = document.location.pathname.split("/")
            if ($.inArray("averaged_report", path_data) > -1) {
                new_link = "https://" + orgnl_url + "/../fov_prom.html";
            }
            $("#fov_prom a").attr("href", new_link)
            var tmp = orgnl_url.split("/")
            var orgnl_dir = tmp[tmp.length -2]
            $("#search_gene input[name*='dir']").attr("value", orgnl_dir)
            $("#fov_prom").show();
            $("#search_gene").show();
        }
    });
});
