$(function () {
    'use strict';
    var files4upload = [];
    var uploaded_files = 0;

    /* Toggling TOC items */
    $(".toggle").click(function(){
        var info_block_id  = $(this).attr("id").split("_");
        $("#info div").hide();
        $(".toggle").css("text-decoration", "none");
        $("#" + info_block_id).show();
        $(this).css("text-decoration", "underline");
        
    });

    $("#type_microarray").click(function(){
        $("#organism_row").hide();
        $("#mirna_true").attr("checked", true);
        $("#mirna_false").attr("checked", false);
        $("#mirna_row").show();
        $("#fileupload").show();
        $("#expert_form").hide();
    });
    $("#type_rnaseq").click(function(){
        $("#organism_row").show();
        $("#mirna_true").attr("checked", true);
        $("#mirna_false").attr("checked", false);    
        $("#mirna_row").show();
        $("#fileupload").show();
        $("#expert_form").hide();

    });
    $("#type_chipseq").click(function(){
        $("#organism_row").show();
        $("#mirna_true").attr("checked", false);
        $("#mirna_false").attr("checked", true);
        $("#mirna_row").show();
        $("#fileupload").show();
        $("#expert_form").hide();

    });
    $("#type_expert").click(function(){
        $("#organism_row").hide();
        $("#mirna_row").hide();
        $("#fileupload").hide();
        $("#expert_form").show();
    });
    $("#submit_user_data").click(function(){
        var validate_result = validate_user_data();
        if (validate_result) {
            submit_user_data();
        }
    });

    /* fileupload bindings */
    $('#fileupload').bind('fileuploadadd', function (e, data) {
        if (files4upload.indexOf(data.files[0].name) !== -1){
            data.files[0].error = "Duplicated";
        }
    });
    $('#fileupload').bind('fileuploadadded', function (e, data) {
        if (data.files[0].error === null) {
            files4upload.push(data.files[0].name);
        }
    });

    $('#fileupload').bind('fileuploadfailed', function (e, data) {
        if (data.files[0].error === null) {
            files4upload.splice(files4upload.indexOf(data.files[0].name), 1);
        }
    });
    
    $('#fileupload').bind('fileuploadstarted', function (e, data) {
        $(".cancel").hide();
    });

    $('#fileupload').bind('fileuploadcompleted', function (e, data) {
        uploaded_files += 1;
        if (uploaded_files == files4upload.length) {
            var validate_result = validate_user_data();
            if (validate_result) {
                submit_user_data();
            }
            else {
                $(".span7").hide();
                $("#submit_user_data").show();
                $("#brief_instructions").html("Please fill missing values and click \"Submit\" button.");
            }
        }
    });

    $('#fileupload').fileupload({
        maxChunkSize: 10000000,
        acceptFileTypes: /(\.|\/)(bed|cel|gz|bz2|zip)$/i
    });
});

function validate_user_data() {
    var validate_result = true;

    if ($("#type_rnaseq").attr("checked") === "checked" || $("#type_chipseq").attr("checked") === "checked") {
        if ($("#organism_row input:checked").length === 0) {
            alert("Please choose one of organisms.");
            $("#organism_row").css("border", "2px solid red");
            validate_result = false;
        }
    }
    return validate_result;
}

function submit_user_data() {
    var email = $("#email").val();
    var project = $("#project").val();
    var type = $("#type_row input:checked").val();
    var organism = $("#organism_row input:checked").val() === undefined ? "" : $("#organism_row input:checked").val();
    var mirna = $("#mirna_row input:checked").val();
    $(".container").css('height', $(".container").css('height'));
    $(".container").css('width', $(".container").css('width'));
    $(".container").css('border', 'none');
    $(".container").html("<img src=\"//mara.unibas.ch/img/loader.gif\" alt=\"loader\">");

    img_margin_top = Math.round($(".container").height()/2 - 33);
    img_margin_left =  Math.round($(".container").width()/2 - 33);
    console.log("img_margin_left: " + img_margin_left);
    $(".container img").css('margin-top', img_margin_top + "px");
    $(".container img").css('margin-left', img_margin_left + "px");

    $.post("/fcgi/mara_dev1/run", {
        "email": email,
        "project": project,
        "type": type,
        "organism": organism,
        "mirna": mirna
    },
           function(x){window.location = window.location.origin + "/ISMARA/scratch/" + x + "/ismara_report";
                      });
    
}

function validateExpertForm() {
    /* Test if at least one file is submitted */
    if (id == "#expert_form") {
        /* Test if there is something longer than that 3 chars for email */
        if ($("#expr_table").val() == "" || $("#sitecount_table").val() == "") {
            alert("Please supply oll necessary files.");
            return false;
        }
    }
    $('<input>').attr({
        type: 'hidden',
        id: 'expert_email',
        name: 'email',
        value: $("#email").val()
    }).appendTo('#expert_form');
    $('<input>').attr({
        type: 'hidden',
        id: 'expert_project',
        name: 'project',
        value: $("#project").val()
    }).appendTo('#expert_form');

}
    
