/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: initbinnumconfig.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include "interspecies.h"
#include "initbins.h"
#include <gsl/gsl_rng.h>

/*  Given a GArray containing numbers n1, n2, n3, ...
 *  puts n1 windows into 1st bin, n2 windows into 2nd bin, etc.
 *
 *  if usedimer, double each value of occset into 2 bins
 */


/* Erik van Nimwegen June 29 2005                             *
 * If the parameters of the -I option has less colours than the number
   of initialized prior WMs then we add bins for these prior WMs *
*/




int initbinnumconfig(params *v) 
{
    int n,n1,n2,nwin,windex,num;
    window *currwin,*currpairwin,*win2;
    GPtrArray *binwin1,*binwin0;

    /**put every window in zero color***/
    initbins(v);

    windex=0;
    currwin=&g_array_index((v->win),window,windex);
    currpairwin=NULL;

    binwin0=g_ptr_array_index((v->bin),0);

    for (n=0; n<(v->occset)->len; n++) {
      binwin1=g_ptr_array_new();
      nwin=g_array_index((v->occset),int,n);
        for (n1=0; n1<nwin; n1++) {
	  windex=gsl_rng_uniform_int(v->gslrand, (v->win)->len);
	  currwin=&g_array_index((v->win),window,windex);
	  num = 0;
	  while ((currwin->blocked)||(currwin->colour>0)) {
	    windex=gsl_rng_uniform_int(v->gslrand, (v->win)->len);
	    currwin=&g_array_index((v->win),window,windex);
	    ++num;
	    if(num > ((v->win)->len)*20){
	      fprintf(stderr,"Not enough room in input to put desired number of windows.\n");
	      return 1;
	    }
	  }
	  currwin->colour=n+1;
	  currwin->dir=0;
            
	  for (n2=0; n2<currwin->blockedwins->len; n2++) {
	    win2=g_ptr_array_index((currwin->blockedwins),n2);
	    win2->blocked=1;
	    g_ptr_array_add(win2->blockers,currwin);
	  }
	  g_ptr_array_add(binwin1,currwin);
	  g_ptr_array_remove_fast(binwin0,currwin);
        }
        if (binwin1->len > 0) 
	  g_ptr_array_add((v->bin),binwin1);
        else 
	  g_ptr_array_free(binwin1,TRUE);
    }
    /***add colors for those from the motiffile***/
    while((v->bin)->len < ((v->priorbinbase)->len+1))
      {
	binwin1=g_ptr_array_new();
	g_ptr_array_add((v->bin),binwin1);
      }
    return 0;
}
            
