/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: inittrackedbins.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include "interspecies.h"
#include <stdio.h>

/* The structure sets up a bunch of "tracked bins", these being a
 * cluster of bins pre-specified to be tracked.  
 */

int inittrackedbins(params *v) 
{
	
    int n;
    window *windowhandle;
    GPtrArray *currseq,*binwin1;

    GArray *seq,*start,*colour;
    int thisseq,thisstart,thiscolour;


    FILE* inputfile;

    /* this routine should only be called once, so assume trackedbins
     * aren't initialized yet
     *
     * also note, zero-offset, but trackedbinfile will be 1-offset (as in
     * general colour scheme), so subtract 1
     */

    v->trackedbins=g_ptr_array_new();
    
    inputfile=fopen(v->trackedbinfile,"r");
    seq=g_array_new(TRUE,TRUE,sizeof(int));
    start=g_array_new(TRUE,TRUE,sizeof(int));
    colour=g_array_new(TRUE,TRUE,sizeof(int));

    if (inputfile==NULL) {
        fprintf(stderr, "Input file %s does not exist: continuing\n",v->trackedbinfile);
        return 1;
    }

    while (fscanf(inputfile,"%d  %d  %d",&thisseq,&thisstart,&thiscolour) != EOF) {
        g_array_append_val(seq,thisseq);
        g_array_append_val(start,thisstart);
        g_array_append_val(colour,thiscolour);
    }

    for (n=0; n<seq->len; n++) {
        thiscolour=g_array_index(colour,int,n);
        thisseq=g_array_index(seq,int,n);
        if (thisseq>=(v->seqwin)->len) {
           fprintf(stderr, "Warning: Inconsistent input file %s (bad specified sequence number):\nNot fatal, continuing\n",v->trackedbinfile);
        }
        thisstart=g_array_index(start,int,n);
        currseq=g_ptr_array_index((v->seqwin),thisseq);
        if (thisstart>=currseq->len) {
           fprintf(stderr, "Warning: Inconsistent input file %s (bad specified start position):\nNot fatal, continuing\n",v->trackedbinfile);
        }
        windowhandle=g_ptr_array_index(currseq,thisstart);
        if (windowhandle==NULL) {
           fprintf(stderr, "Warnng: Inconsistent input file %s (no legitimate window here):\nNot fatal, continuing\n",v->trackedbinfile);
        }

        while (thiscolour>(v->trackedbins)->len) {
            binwin1=g_ptr_array_new();
            g_ptr_array_add((v->trackedbins),binwin1);
        }
        binwin1=g_ptr_array_index((v->trackedbins),thiscolour-1);
        g_ptr_array_add(binwin1,windowhandle);
    }

    g_array_free(seq,TRUE);
    g_array_free(start,TRUE);
    g_array_free(colour,TRUE);


    return 0;

}

