/*                        PhyloGibbs                                  */

/*   Algorithm developed by Rahul Siddharthan, Erik van Nimwegen      * 
 *   and Eric D. Siggia at The Rockefeller University, New York       * 
 *                                                                    *
 *   This code copyright (C) 2004 Rahul Siddharthan <rsidd@online.fr> * 
 *   Licensed under the GNU General Public License (see COPYING)      */ 

/* 
 * $Author: rsidd $  
 * $Date: 2005/05/02 08:54:09 $ 
 * $Id: moveshiftweight.c,v 1.1 2005/05/02 08:54:09 rsidd Exp $ 
 */

#include "interspecies.h"
#include "wminteg.h"
#include "math.h"

double moveshiftweight(params *v, oneshiftmove *trialmove)
{
    double weight1,tmpweight,bgw,wmw;
    double count[4],ocount[4], tcount[4];  /* A C G T */
    int pn,n,m,oldbincount,newbincount,pnlimit;
    
    GPtrArray *wincol1, *wincol2;
    GPtrArray *thispriorbinbase;
    GArray *onebinbase;
    GArray *thiswinbase;
    window *wintmp1, *wintmp2;
    
    weight1=0;
    
    wincol1=g_ptr_array_index((v->bin),trialmove->bin);
    oldbincount=wincol1->len;
    newbincount=trialmove->newbin->len;
    assert(oldbincount == newbincount);
    
    /**check prior exists****/
    if((v->priorbinbase)->len > trialmove->bin-1)
      {
	thispriorbinbase = g_ptr_array_index(v->priorbinbase,(trialmove->bin)-1);
      }
    else
      {
	thispriorbinbase = NULL;
      }

    if (v->rcsymm)
        pnlimit=v->wwidth/2;
    else
        pnlimit=v->wwidth;
    /**run over all columns***/
    for (pn=0; pn<pnlimit; pn++) {
        /**set counts to zero in each column**/
        for (n=0; n<4; n++) {
            count[n]=0.0;
            ocount[n]=0.0;
        }
	
	wincol1=g_ptr_array_index((v->bin),trialmove->bin);
	bgw = 0;
	for (n=0; n<wincol1->len; n++) 
	  {
	    wintmp1=g_ptr_array_index(wincol1,n);
	    if (v->rcsymm) 
	      {
		weight1=weight1+g_array_index(wintmp1->bgcount,double,v->wwidth-1-pn);
		weight1=weight1+g_array_index(wintmp1->bgcount,double,pn);
		thiswinbase=g_ptr_array_index(wintmp1->basecount,v->wwidth-1-pn);
		for (m=0; m<4; m++) 
		  ocount[m]=ocount[m]+g_array_index(thiswinbase,double,3-m);
		thiswinbase=g_ptr_array_index(wintmp1->basecount,pn);
		for (m=0; m<4; m++) 
		  ocount[m]=ocount[m]+g_array_index(thiswinbase,double,m);
	      } 
	    else 
	      {
		if (wintmp1->dir) 
		  {
		    bgw += g_array_index(wintmp1->bgcount,double,v->wwidth-1-pn);
		    thiswinbase=g_ptr_array_index(wintmp1->basecount,v->wwidth-1-pn);
		    for (m=0; m<4; m++) 
		      ocount[m]=ocount[m]+g_array_index(thiswinbase,double,3-m);
		  } 
		else 
		  {
		    bgw += g_array_index(wintmp1->bgcount,double,pn);
		    thiswinbase=g_ptr_array_index(wintmp1->basecount,pn);
		    for (m=0; m<4; m++) 
		      ocount[m]=ocount[m]+g_array_index(thiswinbase,double,m);
		  }
	      }
	  }
	/**check prior exists****/
	if(thispriorbinbase != NULL)
	  {
	    onebinbase = g_ptr_array_index(thispriorbinbase,pn);
	    for(m=0;m<4;++m)
	      {
		tcount[m] = g_array_index(onebinbase,double,m);
	      }
	    wmw = wminteg(ocount[0]+tcount[0],ocount[1]+tcount[1],ocount[2]+tcount[2],ocount[3]+tcount[3]);
	    wmw -= wminteg(tcount[0],tcount[1],tcount[2],tcount[3]);
	  }
	else
	  {
	    wmw = wminteg(ocount[0],ocount[1],ocount[2],ocount[3]);
	  }
	weight1=weight1-wmw+bgw;
    	
	wincol1=trialmove->newbin;
	tmpweight = 0.0;
	wincol2=g_ptr_array_index((v->bin),trialmove->bin);
	bgw = 0.0;
	for (n=0; n<wincol1->len; n++) 
	  {
	    wintmp1=g_ptr_array_index(wincol1,n);
	    if (v->rcsymm) 
	      {
		weight1=weight1-g_array_index(wintmp1->bgcount,double,v->wwidth-1-pn);
		weight1=weight1-g_array_index(wintmp1->bgcount,double,pn);
		thiswinbase=g_ptr_array_index(wintmp1->basecount,v->wwidth-1-pn);
		for (m=0; m<4; m++) 
		  count[m]=count[m]+g_array_index(thiswinbase,double,3-m);
		thiswinbase=g_ptr_array_index(wintmp1->basecount,pn);
		for (m=0; m<4; m++) 
		  count[m]=count[m]+g_array_index(thiswinbase,double,m);
	      } 
	    else 
	      {
		wintmp2=g_ptr_array_index(wincol2,n);
		if (wintmp2->dir) 
		  {
		    bgw += g_array_index(wintmp1->bgcount,double,v->wwidth-1-pn);
		    thiswinbase=g_ptr_array_index(wintmp1->basecount,v->wwidth-1-pn);
		    for (m=0; m<4; m++) 
		      count[m]=count[m]+g_array_index(thiswinbase,double,3-m);
		  } 
		else 
		  {
		    bgw += g_array_index(wintmp1->bgcount,double,pn);
		    thiswinbase=g_ptr_array_index(wintmp1->basecount,pn);
		    for (m=0; m<4; m++) 
		      count[m]=count[m]+g_array_index(thiswinbase,double,m);
		  }
	      }
	  }
	/**check prior exists****/
	if(thispriorbinbase != NULL)
	  {
	    onebinbase = g_ptr_array_index(thispriorbinbase,pn);
	    for(m=0;m<4;++m)
	      {
		tcount[m] = g_array_index(onebinbase,double,m);
	      }
	    wmw = wminteg(count[0]+tcount[0],count[1]+tcount[1],count[2]+tcount[2],count[3]+tcount[3]);
	    wmw -= wminteg(tcount[0],tcount[1],tcount[2],tcount[3]);
	  }
	else
	  {
	    wmw = wminteg(count[0],count[1],count[2],count[3]);
	  }
	weight1=weight1+wmw-bgw;
    }
       
    return (weight1);
}


