typedef struct { /* this struct describes phylo tree for one window */
    double c;       /* pre-factor for this tree */
    GPtrArray *F;   /* each element is a list of ints, indexing *bases
                     * and *mulist */
    GNode *tree;    /* a pruned copy of the main v->tree */
                    /* the ->data of each node is a GPtrArray
                     * containing a (double *) to q, and if applicable,
                     * the label and the species index */
} base_tree;


GNode* clone_gtree(GNode *oldtree, GNode *oldnotednode, GNode **newnotednode,
                   int copyq);
void get_gtree_leaves(GNode *oldtree, GPtrArray **leaves);
void get_qvalues(GNode *tree,GPtrArray **qvalues);
void merge_node(GNode *node1, GNode *node2);
int getclosingbracket(char* str1, int nl);
void stringtotree(char* treestr, GNode **currnode, int startpos);
void treeprint(FILE *stream, GNode *treenode);
void remove_node_from_gtree(GNode *thisnode);
base_tree* make_base_tree(params *v, window *win);
void prune_trees(GPtrArray **treelist);
