#ifndef RAND_H
#define RAND_H

enum Boolean {False, True};
// LongRand class implements a random number stream, using
// Terry's package
class LongRand {
public:
    // constructor: has to seed the random number generator
    // otherwise it initializes itself from the clock
    LongRand(long seed = -1); 
    // destructor: nothing to do 
    ~LongRand() {} 
    // interface: I'll just leave the functions use the same
    // stream, I could have various random number generators
    // for uniform ints, or uniform doubles between 0 and 1, etc.
    // Return [0, n - 1]
    unsigned long Uniform(double n);
    // Return true if a random double is less than the given probability 
    Boolean BiasedCoinFlip(double prob); 
    // Return [0,1) - just calls knuth_random
    double Next();
    long Seed() {return seed;}
private:
    long seed;

    // these variables are static in Terry's original
    // code, I probably don't need the storage class
    // specifier here, since they are wrapped in an object
    int inext;
    int inextp;
    long ma[56];

    // all the functions that are used for implementation
    double knuth_random();
    long seed_random(long seed);

    // Terry also has various functions to restore the state of the
    // ransom number generator, but I won't need them here
};
#endif
