package Exon;

use strict;
                                                                                                                                                             
sub new  {
    my $that = shift;
    my $class = ref($that) || $that;
    my @line = @_;
    
    my $exonId     = $line[0];
    my $cloneId    = $line[1];
    my $exonStart  = $line[2];
    my $exonEnd    = $line[3];
    my $exonSeq    = $line[4];
    my $chromStart = $line[5];
    my $chromEnd   = $line[6];
    my $chromSeq   = $line[7];
    my $strand     = $line[8];
    my $score      = $line[9];
    my $lchex = length($chromSeq);
    my $lclex = length($exonSeq);

    if ($lchex != $lclex) {
        print "Exon::new -> Unsuspected Case : Mismatch lengths lchex-lclex $lchex-$lclex\n";
        print "cloneId : $cloneId\n";
        print "ClS : $exonSeq\n"; 
        die "CHS : $chromSeq\n"; 
    }

    if (($strand eq '-') && ($chromStart < $chromEnd)) {
	my $t = $chromStart;
	$chromStart = $chromEnd;
	$chromEnd = $t;
    }

    my $self = {
       exonId     => $exonId,
       cloneId    => $cloneId,
       exonStart  => $exonStart,
       exonEnd    => $exonEnd,
       exonSeq	  => $exonSeq,
       chromStart => $chromStart,
       chromEnd   => $chromEnd,
       chromSeq   => $chromSeq,
       strand     => $strand,
       score      => $score,
       m          => 0,
       mm         => 0,
       ins        => 0,
       del        => 0,
       distDel    => [],
       distDelLen => 0,
       distIns    => [],
       distInsLen => 0
    };
    bless($self, $class);
    return $self;
};

sub process {
    my $self = shift;
    my ($a, $b);
    my ($dL, $iL) = (0, 0);
    my ($dLength, $iLength) = (0, 0);
    for (my $i = 0; $i < length($self->{exonSeq}); $i++) {
         $a = substr($self->{exonSeq}, $i, 1);
         $b = substr($self->{chromSeq}, $i, 1);
         #print "$a $b\n";
         if (($a eq $b) || ($a eq 'n') || ($b eq 'n') || ($a eq 'N') || ($b eq 'N')) {
             if (($a ne '-') && ($b ne '-') && ($b ne '*')) {
                 $self->{m}++;
                 #print "$iLength $dLength\n";
                 if ($dLength != 0) {
                     $self->{distDel}[$dL] = $dLength;
                     $dL++;
                     $dLength = 0;
                 }
                 if ($iLength != 0) {
                     $self->{distIns}[$iL] = $iLength;
                     $iLength = 0;
                     $iL++;
                 }
             }
             if (($b eq '-') || ($b eq '*')) {
                 $self->{ins}++;
                 $iLength++;
                 if ($dLength != 0) {
                    $self->{distDel}[$dL] = $dLength;
                    $dL++;
                    $dLength = 0;
                 }
             }
             elsif ($a eq '-') {
                 $self->{del}++;
                 $dLength++;
                 if ($iLength != 0) {
                     $self->{distIns}[$iL] = $iLength;
                     $iLength = 0;
                     $iL++;
                 }
             }
         }  
         elsif ($a eq '-') {
                $self->{del}++;
                $dLength++;
                if ($iLength != 0) {
                    $self->{distIns}[$iL] = $iLength;
                    $iLength = 0;
                    $iL++;
                }
         }
         elsif (($b eq '-') || ($b eq '*')) {
                $self->{ins}++;
                $iLength++;
                if ($dLength != 0) {
                    $self->{distDel}[$dL] = $dLength;
                    $dL++;
                    $dLength = 0;
                }
         }
         else {
               $self->{mm}++; 
               if ($dLength != 0) {
                 $self->{distDel}[$dL] = $dLength;
                 $dL++;
                 $dLength = 0;
               }
               if ($iLength != 0) {
                 $self->{distIns}[$iL] = $iLength;
                 $iLength = 0;
                 $iL++;
               }
        }
    }
    if ($dLength != 0) {
        $self->{distDel}[$dL] = $dLength;
        $dL++;
        $dLength = 0;
    }
    if ($iLength != 0) {
        $self->{distIns}[$iL] = $iLength;
        $iLength = 0;
        $iL++;
    }
    $self->{distDelLen} = $dL;
    $self->{distInsLen} = $iL;
    #print "$dL $iL\n";
}

sub set_data {
    my $self = shift;
                                                                                                                                                             
    process($self);
}


sub print {
    my $self = shift;

    print "$self->{exonSeq}\n";
    print "$self->{chromSeq}\n\n";
}

sub print_distDel {
    my $self = shift;
    
    for (my $i = 0; $i < $self->{distDelLen}; $i++) {
         print "$self->{distDel}[$i]\n";
    }
}

1;          
