package Parameters;

use strict;
use warnings;

sub new {
	my $that = shift;
        my $class = ref($that) || $that;

	my $file = shift;
	unless (defined($file) && -e $file) {
		die "input file is expected\n";
	}

	my @line;
	my %data = ();
	my $count = 0;
	my $prob = 1.0;
  	my ($k, $tmp);
 	open(IN, $file) || die "Could not open $file : $!\n";
	while (<IN>) {
		if (/^\s*$/) {
			next;
		}
		chomp;
		@line = split(" ", $_);
		if ($line[0] eq '#') {
			if (index($line[1], 'score_splice') != -1) {
				$count++;
			}	
			next;
		}
		if (index($line[0], 'score_splice') != -1) {
			$k = substr($line[0], 13, 4);
			$prob -= $line[1];
			$data{$k} = $line[1];
		}
	}
	close(IN);
	my @tr = ('t', 'c', 'a', 'g');
    	my ($ro, $ri, $li, $lo);
	for (my $i = 0; $i < 256; $i++) {
        	$ro = $i%4;
         	$ri = (int($i/4)) % 4;
         	$li = (int($i/16)) %4;
         	$lo = int($i/64);
         	$k = "$tr[$lo]$tr[$li]$tr[$ri]$tr[$ro]";
       		if (! exists($data{$k})) {
	 		$data{$k} = $prob/$count;
		}
		$tmp = $data{$k};
		if (exists($data{$tr[$lo].$tr[$li].$tr[$ri].'n'})) {
			$data{$tr[$lo].$tr[$li].$tr[$ri].'n'} += $tmp;
		}
		else {
			$data{$tr[$lo].$tr[$li].$tr[$ri].'n'} = $tmp;
		}
		if (exists($data{$tr[$lo].$tr[$li].'n'.$tr[$ro]})) {
			$data{$tr[$lo].$tr[$li].'n'.$tr[$ro]} += $tmp;
		}
		else {
			$data{$tr[$lo].$tr[$li].'n'.$tr[$ro]} = $tmp;
		}
		if (exists($data{$tr[$lo].'n'.$tr[$ri].$tr[$ro]})) {
                        $data{$tr[$lo].'n'.$tr[$ri].$tr[$ro]} += $tmp;                                                 
                }
                else { 
                       $data{$tr[$lo].'n'.$tr[$ri].$tr[$ro]} = $tmp;
                }
		if (exists($data{'n'.$tr[$li].$tr[$ri].$tr[$ro]})) {
			$data{'n'.$tr[$li].$tr[$ri].$tr[$ro]} += $tmp;
		}
		else {
			$data{'n'.$tr[$li].$tr[$ri].$tr[$ro]} = $tmp;
		}
		if (exists($data{$tr[$lo].$tr[$li].'n'.'n'})) {
			$data{$tr[$lo].$tr[$li].'n'.'n'} += $tmp;
		}
		else {
			$data{$tr[$lo].$tr[$li].'n'.'n'} += $tmp;
		}
		if (exists($data{$tr[$lo].'n'.$tr[$ri].'n'})) {
			$data{$tr[$lo].'n'.$tr[$ri].'n'} += $tmp;
		}
		else {
			$data{$tr[$lo].'n'.$tr[$ri].'n'} = $tmp;
		}
		if (exists($data{'n'.$tr[$li].$tr[$ri].'n'})) {
			$data{'n'.$tr[$li].$tr[$ri].'n'} += $tmp;
		}
		else {
			$data{'n'.$tr[$li].$tr[$ri].'n'} = $tmp;
		}
		if (exists($data{$tr[$lo].'n'.'n'.$tr[$ro]})) {
			$data{$tr[$lo].'n'.'n'.$tr[$ro]} += $tmp;
		}
		else {
			$data{$tr[$lo].'n'.'n'.$tr[$ro]} = $tmp;
		}
		if (exists($data{'n'.$tr[$li].'n'.$tr[$ro]})) {
			$data{'n'.$tr[$li].'n'.$tr[$ro]} += $tmp;
		}
		else {
			$data{'n'.$tr[$li].'n'.$tr[$ro]} = $tmp;
		}
		if (exists($data{'n'.'n'.$tr[$ri].$tr[$ro]})) {
			$data{'n'.'n'.$tr[$ri].$tr[$ro]} += $tmp;
		}
		else {
			$data{'n'.'n'.$tr[$ri].$tr[$ro]} = $tmp;
		}
		if (exists($data{$tr[$lo].'n'.'n'.'n'})) {
			$data{$tr[$lo].'n'.'n'.'n'} += $tmp;
		}
		else {
			$data{$tr[$lo].'n'.'n'.'n'} = $tmp;
		}
		if (exists($data{'n'.$tr[$li].'n'.'n'})) {
			$data{'n'.$tr[$li].'n'.'n'} += $tmp;
		}
		else {
			$data{'n'.$tr[$li].'n'.'n'} = $tmp;
		}
		if (exists($data{'n'.'n'.$tr[$ri].'n'})) {
			$data{'n'.'n'.$tr[$ri].'n'} += $tmp;
		}
		else {
			$data{'n'.'n'.$tr[$ri].'n'} = $tmp;
		}
		if (exists($data{'n'.'n'.'n'.$tr[$ro]})) {
			$data{'n'.'n'.'n'.$tr[$ro]} += $tmp;
		}
		else {
			$data{'n'.'n'.'n'.$tr[$ro]} = $tmp;
		}
		if (exists($data{'n'.'n'.'n'.'n'})) {
			$data{'n'.'n'.'n'.'n'} += $tmp;
		}
		else {
			$data{'n'.'n'.'n'.'n'} = $tmp;
		}	
	}
	my $self = {};
	my $n;
	foreach $k (keys %data) {
		$n = count_n($k);
		if ($n == 0) {
			$self->{$k} = log($data{$k}) + 4*log(4);
		}
		elsif ($n == 1) {
			$self->{$k} = log($data{$k}) + 3*log(4);
		}
		elsif ($n == 2) {
			$self->{$k} = log($data{$k}) + 2*log(4);
		}
		elsif ($n == 3) {
			$self->{$k} = log($data{$k}) + log(4);
		}
		elsif ($n == 4) {
			$self->{$k} = log($data{$k});
		}
		else {
			die "Bad Count Number\n";
		}
		delete($data{$k});
	}
	bless($self, $class);
        return $self;
}
					
sub count_n {
	my $s = shift;
	my $count = 0;
	for (my $i = 0; $i < length($s); $i++) {
		if (substr($s, $i, 1) eq 'n') {
			$count++;
		}
	}
	return $count;
}

sub print {
	my $self = shift;
	
	my @tr = ('t', 'c', 'a', 'g', 'n');
        my ($ro, $ri, $li, $lo, $k);

	for (my $i = 0; $i < 625; $i++) {
        	$ro = $i%5;
                $ri = (int($i/5)) % 5;
                $li = (int($i/25)) %5;
                $lo = int($i/125);
                $k = "$tr[$lo]$tr[$li]$tr[$ri]$tr[$ro]";		
		printf "%s %.10f\n", $k, $self->{$k};
	}
}

sub print_data {
	my $self = shift;
	my $out = shift;
	my @tr = ('t', 'c', 'a', 'g', 'n');
        my ($ro, $ri, $li, $lo, $k);

	for (my $i = 0; $i < 625; $i++) {
                $ro = $i%5;
                $ri = (int($i/5)) % 5;
                $li = (int($i/25)) %5;
                $lo = int($i/125);
                $k = "$tr[$lo]$tr[$li]$tr[$ri]$tr[$ro]";
                printf $out "%s %.10f\n", $k, $self->{$k};
        }
}

1;
	   	
