COMPILER = g++
BIN = bin/
LIBS =  -lm 
CCFLAGS = -O3 -D_MARKOV -DMARKOV_ORDER=2 -DCONTEXT_SIZE=5 -D_OPTIMIZE_MOTIFORIENTATION -D_OPTIMIZE_PROTECTED_ACCESS  -D_OPTIMIZE_CAREFULCSP -D_OPTIMIZE_WMINDEX -D_MULTIPLE_SEQUENCES -D_MEMORY_HACK #-D_WTMX_BIAS
STUBBMSCCFLAGS = -D_OPTIMIZE_CACHESEQUENCEPROBABILITIES -D_FIXED_WIDTH #-D_PRUNE_MOTIFS 

all:  clean stubbms stubbms_modifyalignments 

stubbms: Makefile stubbms.cpp util.o parameters.o parameters_h0.o sequence.o windowiterator.o wtmx.o lagan.o
	${COMPILER} ${CCFLAGS} ${STUBBMSCCFLAGS} ${LIBS} -o ${BIN}/stubbms stubbms.cpp  util.o parameters.o parameters_h0.o sequence.o windowiterator.o wtmx.o lagan.o

stubbms_modifyalignments: Makefile stubbms_modifyalignments.cpp util.o parameters_nooverlaps.o parameters_h0.o sequence.o windowiterator.o wtmx.o lagan.o
	${COMPILER} ${CCFLAGS} ${STUBBMSCCFLAGS} ${LIBS} -o ${BIN}/stubbms_modifyalignments stubbms_modifyalignments.cpp  util.o parameters_nooverlaps.o parameters_h0.o sequence.o windowiterator.o wtmx.o lagan.o

util.o: Makefile util.cpp util.h parameters.h typedefs.h parameters.o
	${COMPILER} ${CCFLAGS} -c util.cpp

parameters.o: Makefile parameters.cpp parameters.h typedefs.h sequence.o wtmx.o
	${COMPILER} ${CCFLAGS} -c parameters.cpp 

parameters_nooverlaps.o: Makefile parameters.cpp parameters.h typedefs.h sequence.o wtmx.o
	${COMPILER} ${CCFLAGS} -D_OVERLAPS -o parameters_nooverlaps.o -c parameters.cpp 

parameters_h0.o: Makefile parameters_h0.cpp parameters.h typedefs.h sequence.o wtmx.o
	${COMPILER} ${CCFLAGS} -c parameters_h0.cpp 

sequence.o: Makefile sequence.cpp sequence.h
	${COMPILER} ${CCFLAGS} -c sequence.cpp

windowiterator.o: Makefile windowiterator.cpp sequence.h
	${COMPILER} ${CCFLAGS} -c windowiterator.cpp

fastafile.o: Makefile fastafile.cpp fastafile.h sequence.h
	${COMPILER} ${CCFLAGS} -c fastafile.cpp

lagan.o: Makefile lagan.cpp sequence.h
	${COMPILER} ${CCFLAGS} -c lagan.cpp

wtmx.o: Makefile wtmx.cpp wtmx.h typedefs.h 
	${COMPILER} ${CCFLAGS} -c wtmx.cpp

clean: 
	rm -rf *.o core *~
